/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.ArmorDropTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ArmorDropInfo;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ArmorDropsJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniTracker;
import at.hannibal2.skyhanni.utils.tracker.TrackerData;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002GHB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010&\u001a\u00020%2\b\u0010$\u001a\u0004\u0018\u00010#\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*J\r\u0010+\u001a\u00020\u0006\u00a2\u0006\u0004\b+\u0010\u0003R\u001c\u00100\u001a\n -*\u0004\u0018\u00010,0,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u001b\u00106\u001a\u0002018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\"\u0010;\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u00010\u00100\u00100:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\"\u0010@\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010B\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010E\u001a\u00020D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010F\u00a8\u0006I"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "event", "", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker$ArmorDropType;", "drop", "addDrop", "(Lat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker$ArmorDropType;)V", "Lat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker$Data;", "data", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker$Data;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "checkArmor", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "", "getDropsPerHour", "(Lat/hannibal2/skyhanni/features/garden/CropType;)D", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "resetCommand", "Lat/hannibal2/skyhanni/config/features/garden/ArmorDropTrackerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/ArmorDropTrackerConfig;", "config", "Ljava/util/regex/Pattern;", "armorPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getArmorPattern", "()Ljava/util/regex/Pattern;", "armorPattern", "", "hasArmor", "Z", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ArmorDropInfo;", "armorDropInfo", "Ljava/util/Map;", "currentArmorDropChance", "D", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastCalculationTime", "J", "Data", "ArmorDropType", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nArmorDropTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArmorDropTracker.kt\nat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,176:1\n11420#2,9:177\n13346#2:186\n13347#2:188\n11429#2:189\n11420#2,9:201\n13346#2:210\n13347#2:212\n11429#2:213\n1#3:187\n1#3:211\n1782#4,4:190\n1782#4,4:214\n12#5,7:194\n*S KotlinDebug\n*F\n+ 1 ArmorDropTracker.kt\nat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker\n*L\n122#1:177,9\n122#1:186\n122#1:188\n122#1:189\n146#1:201,9\n146#1:210\n146#1:212\n146#1:213\n122#1:187\n146#1:211\n123#1:190,4\n147#1:214,4\n129#1:194,7\n*E\n"})
public final class ArmorDropTracker {
    @NotNull
    public static final ArmorDropTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern armorPattern$delegate;
    private static boolean hasArmor;
    @NotNull
    private static final SkyHanniTracker<Data> tracker;
    @NotNull
    private static Map<String, ArmorDropInfo> armorDropInfo;
    private static double currentArmorDropChance;
    private static long lastCalculationTime;

    private ArmorDropTracker() {
    }

    private final ArmorDropTrackerConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().farmingArmorDrop;
    }

    private final Pattern getArmorPattern() {
        return (Pattern)armorPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        hasArmor = false;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        for (ArmorDropType dropType : ArmorDropType.getEntries()) {
            if (!Intrinsics.areEqual(dropType.getChatMessage(), event.getMessage())) continue;
            this.addDrop(dropType);
            if (!this.getConfig().hideChat) continue;
            event.setBlockedReason("farming_armor_drops");
        }
    }

    private final void addDrop(ArmorDropType drop2) {
        tracker.modify(arg_0 -> ArmorDropTracker.addDrop$lambda$3(drop2, arg_0));
    }

    private final List<Searchable> drawDisplay(Data data2) {
        List list;
        List $this$drawDisplay_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u244, "\u00a77Armor Drop Tracker:", null, null, null, 14, null);
        for (Map.Entry<ArmorDropType, Integer> entry : CollectionUtils.INSTANCE.sortedDesc(data2.getDrops()).entrySet()) {
            ArmorDropType drop2 = entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            String dropName = drop2.getDropName();
            CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u244, " \u00a77- \u00a7e" + NumberUtil.INSTANCE.addSeparators(amount) + "x " + dropName, dropName, null, null, 12, null);
        }
        return CollectionsKt.build(list);
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        if (!this.getConfig().enabled) {
            return;
        }
        if (!hasArmor) {
            return;
        }
        if (!GardenAPI.INSTANCE.hasFarmingToolInHand()) {
            return;
        }
        Position position = this.getConfig().pos;
        Intrinsics.checkNotNullExpressionValue(position, "pos");
        tracker.renderDisplay(position);
    }

    @SubscribeEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getNewIsland() == IslandType.GARDEN) {
            tracker.firstUpdate();
        }
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        if (!this.getConfig().enabled) {
            return;
        }
        this.checkArmor();
    }

    /*
     * WARNING - void declaration
     */
    private final void checkArmor() {
        int n;
        void $this$mapNotNullTo$iv$iv;
        ItemStack[] $this$mapNotNull$iv = InventoryUtils.INSTANCE.getArmor();
        boolean $i$f$mapNotNull = false;
        ItemStack[] itemStackArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n2 = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n2; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            NEUInternalName nEUInternalName = it;
            if ((nEUInternalName != null && (nEUInternalName = ItemUtils.INSTANCE.getInternalName((ItemStack)nEUInternalName)) != null ? nEUInternalName.asString() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$count$iv = (List)destination$iv$iv;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!INSTANCE.getArmorPattern().matcher(it).matches() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int armorPieces = n;
        hasArmor = armorPieces > 1;
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        ArmorDropsJson armorDropsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "ArmorDrops";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            armorDropsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, ArmorDropsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        ArmorDropsJson data2 = armorDropsJson;
        armorDropInfo = data2.getSpecialCrops();
    }

    /*
     * WARNING - void declaration
     */
    public final double getDropsPerHour(@Nullable CropType crop) {
        if (crop == null) {
            return 0.0;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastCalculationTime), DurationKt.toDuration(5, DurationUnit.SECONDS)) > 0) {
            Object object;
            int pieceCount;
            int n;
            void $this$count$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            lastCalculationTime = SimpleTimeMark.Companion.now-uFjCsEo();
            String armorDropName = crop.getSpecialDropType();
            Object object2 = armorDropInfo.get(armorDropName);
            if (object2 == null || (object2 = ((ArmorDropInfo)object2).getArmorType()) == null) {
                return 0.0;
            }
            Object armorName = object2;
            ItemStack[] itemStackArray = InventoryUtils.INSTANCE.getArmor();
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n2 = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n2; ++j) {
                String it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                NEUInternalName nEUInternalName = it;
                if ((nEUInternalName != null && (nEUInternalName = ItemUtils.INSTANCE.getInternalName((ItemStack)nEUInternalName)) != null ? nEUInternalName.asString() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!(StringsKt.contains$default((CharSequence)it, (CharSequence)armorName, false, 2, null) || StringsKt.contains$default((CharSequence)it, "FERMENTO", false, 2, null)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = pieceCount = count$iv;
            }
            if ((object = armorDropInfo.get(armorDropName)) == null || (object = ((ArmorDropInfo)object).getChance()) == null) {
                return 0.0;
            }
            Object dropRates = object;
            double dropRate = 0.0;
            if (pieceCount > 0 && dropRates.size() >= pieceCount) {
                dropRate = ((Number)dropRates.get(pieceCount - 1)).doubleValue();
            }
            currentArmorDropChance = dropRate * (double)60 * 60.0 / (double)100;
        }
        return currentArmorDropChance;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.farmingArmorDropsEnabled", "garden.farmingArmorDrop.enabled", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.farmingArmorDropsHideChat", "garden.farmingArmorDrop.hideChat", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.farmingArmorDropsPos", "garden.farmingArmorDrop.pos", null, 8, null);
        event.move(8, "#profile.garden.farmArmorDrops", "#profile.garden.armorDropTracker", ArmorDropTracker::onConfigFix$lambda$9);
    }

    public final void resetCommand() {
        tracker.resetCommand();
    }

    private static final Data tracker$lambda$0() {
        return new Data();
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.garden.armorDropTracker;
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNull(it);
        return INSTANCE.drawDisplay(it);
    }

    private static final Unit addDrop$lambda$3(ArmorDropType $drop, Data it) {
        Intrinsics.checkNotNullParameter((Object)$drop, "$drop");
        CollectionUtils.INSTANCE.addOrPut(it.getDrops(), $drop, 1);
        return Unit.INSTANCE;
    }

    private static final JsonElement onConfigFix$lambda$9(JsonElement old) {
        Intrinsics.checkNotNullParameter(old, "old");
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("drops", old);
        return (JsonElement)jsonObject2;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ArmorDropTracker.class, "armorPattern", "getArmorPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ArmorDropTracker();
        armorPattern$delegate = RepoPattern.Companion.pattern("garden.armordrops.armor", "(FERMENTO|CROPIE|SQUASH|MELON)_(LEGGINGS|CHESTPLATE|BOOTS|HELMET)");
        tracker = new SkyHanniTracker<Data>("Armor Drop Tracker", ArmorDropTracker::tracker$lambda$0, ArmorDropTracker::tracker$lambda$1, new Pair[0], ArmorDropTracker::tracker$lambda$2);
        armorDropInfo = MapsKt.emptyMap();
        lastCalculationTime = SimpleTimeMark.Companion.farPast();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\n\u0010\tj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker$ArmorDropType;", "", "", "dropName", "chatMessage", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "Ljava/lang/String;", "getDropName", "()Ljava/lang/String;", "getChatMessage", "CROPIE", "SQUASH", "FERMENTO", "1.8.9"})
    public static final class ArmorDropType
    extends Enum<ArmorDropType> {
        @NotNull
        private final String dropName;
        @NotNull
        private final String chatMessage;
        public static final /* enum */ ArmorDropType CROPIE = new ArmorDropType("\u00a79Cropie", "\u00a76\u00a7lRARE CROP! \u00a7r\u00a7f\u00a7r\u00a79Cropie \u00a7r\u00a7b(Armor Set Bonus)");
        public static final /* enum */ ArmorDropType SQUASH = new ArmorDropType("\u00a75Squash", "\u00a76\u00a7lRARE CROP! \u00a7r\u00a7f\u00a7r\u00a75Squash \u00a7r\u00a7b(Armor Set Bonus)");
        public static final /* enum */ ArmorDropType FERMENTO = new ArmorDropType("\u00a76Fermento", "\u00a76\u00a7lRARE CROP! \u00a7r\u00a7f\u00a7r\u00a76Fermento \u00a7r\u00a7b(Armor Set Bonus)");
        private static final /* synthetic */ ArmorDropType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ArmorDropType(String dropName, String chatMessage) {
            this.dropName = dropName;
            this.chatMessage = chatMessage;
        }

        @NotNull
        public final String getDropName() {
            return this.dropName;
        }

        @NotNull
        public final String getChatMessage() {
            return this.chatMessage;
        }

        public static ArmorDropType[] values() {
            return (ArmorDropType[])$VALUES.clone();
        }

        public static ArmorDropType valueOf(String value) {
            return Enum.valueOf(ArmorDropType.class, value);
        }

        @NotNull
        public static EnumEntries<ArmorDropType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = armorDropTypeArray = new ArmorDropType[]{ArmorDropType.CROPIE, ArmorDropType.SQUASH, ArmorDropType.FERMENTO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R.\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/TrackerData;", "<init>", "()V", "", "reset", "", "Lat/hannibal2/skyhanni/features/garden/farming/ArmorDropTracker$ArmorDropType;", "", "drops", "Ljava/util/Map;", "getDrops", "()Ljava/util/Map;", "setDrops", "(Ljava/util/Map;)V", "1.8.9"})
    public static final class Data
    extends TrackerData {
        @Expose
        @NotNull
        private Map<ArmorDropType, Integer> drops = new LinkedHashMap();

        @Override
        public void reset() {
            this.drops.clear();
        }

        @NotNull
        public final Map<ArmorDropType, Integer> getDrops() {
            return this.drops;
        }

        public final void setDrops(@NotNull Map<ArmorDropType, Integer> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.drops = map2;
        }
    }
}

