/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.contest;

import at.hannibal2.skyhanni.config.features.garden.GardenConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.events.CropClickEvent;
import at.hannibal2.skyhanni.events.FarmingContestEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContestAPI;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContestPhase;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0018\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/features/garden/contest/JacobContestStatsSummary;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/CropClickEvent;", "event", "", "onCropClick", "(Lat/hannibal2/skyhanni/events/CropClickEvent;)V", "Lat/hannibal2/skyhanni/events/FarmingContestEvent;", "onFarmingContest", "(Lat/hannibal2/skyhanni/events/FarmingContestEvent;)V", "", "blocksPerSecond", "", "getBlocksPerSecondColor", "(D)Ljava/lang/String;", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "config", "", "blocksBroken", "I", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "startTime", "J", "1.8.9"})
public final class JacobContestStatsSummary {
    @NotNull
    public static final JacobContestStatsSummary INSTANCE = new JacobContestStatsSummary();
    private static int blocksBroken;
    private static long startTime;

    private JacobContestStatsSummary() {
    }

    private final GardenConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig();
    }

    @SubscribeEvent
    public final void onCropClick(@NotNull CropClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getClickType() != ClickType.LEFT_CLICK) {
            return;
        }
        if (FarmingContestAPI.INSTANCE.getInContest() && event.getCrop() == FarmingContestAPI.INSTANCE.getContestCrop()) {
            int n = blocksBroken;
            blocksBroken = n + 1;
        }
    }

    @SubscribeEvent
    public final void onFarmingContest(@NotNull FarmingContestEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[event.getPhase().ordinal()]) {
            case 1: {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Started tracking your Jacob Contest Blocks Per Second!", false, null, 6, null);
                startTime = SimpleTimeMark.Companion.now-uFjCsEo();
                break;
            }
            case 2: {
                long duration = SimpleTimeMark.passedSince-UwyO8pc(startTime);
                double blocksPerSecond = NumberUtil.INSTANCE.roundTo((double)blocksBroken / (double)Duration.getInWholeSeconds-impl(duration), 2);
                String cropName = event.getCrop().getCropName();
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Stats for " + cropName + " Contest:", false, null, 6, null);
                String time = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, duration, null, false, false, 0, false, 31, null);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Blocks Broken in total: \u00a7e" + NumberUtil.INSTANCE.addSeparators(blocksBroken), false, null, 6, null);
                String color = this.getBlocksPerSecondColor(blocksPerSecond);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Average Blocks Per Second: " + color + blocksPerSecond, false, null, 6, null);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Participated for \u00a7b" + time, false, null, 6, null);
                break;
            }
            case 3: {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "You changed the crop during the contest, resetting the Blocks Per Second calculation..", false, null, 6, null);
                startTime = SimpleTimeMark.Companion.now-uFjCsEo();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        blocksBroken = 0;
    }

    private final String getBlocksPerSecondColor(double blocksPerSecond) {
        return blocksPerSecond > 19.0 ? "\u00a7c" : "\u00a7a";
    }

    public final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden() && this.getConfig().jacobContestSummary;
    }

    static {
        startTime = SimpleTimeMark.Companion.farPast();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FarmingContestPhase.values().length];
            try {
                nArray[FarmingContestPhase.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FarmingContestPhase.STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FarmingContestPhase.CHANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

