/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.contest;

import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ScoreboardData;
import at.hannibal2.skyhanni.events.FarmingContestEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.contest.ContestBracket;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContest;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContestPhase;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockTime;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0011\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010!\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\u0018\u00a2\u0006\u0004\b#\u0010$J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010%\u001a\u00020\n\u00a2\u0006\u0004\b&\u0010'J-\u0010,\u001a\u001a\u0012\u0004\u0012\u00020)\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020)0*0(2\u0006\u0010%\u001a\u00020\n\u00a2\u0006\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001b\u00106\u001a\u0002018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u001b\u00109\u001a\u0002018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00103\u001a\u0004\b8\u00105R\u001b\u0010<\u001a\u0002018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u00103\u001a\u0004\b;\u00105R \u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020 0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010A\u001a\u00020@8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0011\u0010E\u001a\u00020@8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR$\u0010F\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010\f\"\u0004\bI\u0010JR\u0016\u0010L\u001a\u00020K8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010MR\"\u0010N\u001a\u00020@8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010B\u001a\u0004\bO\u0010D\"\u0004\bP\u0010Q\u00a8\u0006R"}, d2={"Lat/hannibal2/skyhanni/features/garden/contest/FarmingContestAPI;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "checkActiveContest", "Lat/hannibal2/skyhanni/features/garden/CropType;", "readCurrentCrop", "()Lat/hannibal2/skyhanni/features/garden/CropType;", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "", "text", "", "getSbDateFromItemName", "(Ljava/lang/String;)Ljava/util/List;", "", "getSbTimeFor", "(Ljava/lang/String;)Ljava/lang/Long;", "time", "Lnet/minecraft/item/ItemStack;", "item", "addContest", "(JLnet/minecraft/item/ItemStack;)V", "Lat/hannibal2/skyhanni/features/garden/contest/FarmingContest;", "createContest", "(JLnet/minecraft/item/ItemStack;)Lat/hannibal2/skyhanni/features/garden/contest/FarmingContest;", "getContestAtTime", "(J)Lat/hannibal2/skyhanni/features/garden/contest/FarmingContest;", "crop", "getContestsOfType", "(Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/util/List;", "Lkotlin/Pair;", "", "", "Lat/hannibal2/skyhanni/features/garden/contest/ContestBracket;", "calculateAverages", "(Lat/hannibal2/skyhanni/features/garden/CropType;)Lkotlin/Pair;", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "timePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTimePattern", "()Ljava/util/regex/Pattern;", "timePattern", "cropPattern$delegate", "getCropPattern", "cropPattern", "sidebarCropPattern$delegate", "getSidebarCropPattern", "sidebarCropPattern", "", "contests", "Ljava/util/Map;", "", "internalContest", "Z", "getInContest", "()Z", "inContest", "contestCrop", "Lat/hannibal2/skyhanni/features/garden/CropType;", "getContestCrop", "setContestCrop", "(Lat/hannibal2/skyhanni/features/garden/CropType;)V", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "startTime", "J", "inInventory", "getInInventory", "setInInventory", "(Z)V", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFarmingContestAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FarmingContestAPI.kt\nat/hannibal2/skyhanni/features/garden/contest/FarmingContestAPI\n+ 2 LorenzUtils.kt\nat/hannibal2/skyhanni/utils/LorenzUtils\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,172:1\n337#2:173\n8#3:174\n8#3:176\n32#3,3:178\n18#3,2:181\n21#3:184\n32#3,3:185\n18#3,2:188\n21#3:191\n1#4:175\n1#4:177\n1#4:183\n1#4:190\n774#5:192\n865#5,2:193\n1279#5,2:195\n1293#5,4:197\n1246#5,4:203\n1863#5,2:207\n462#6:201\n412#6:202\n*S KotlinDebug\n*F\n+ 1 FarmingContestAPI.kt\nat/hannibal2/skyhanni/features/garden/contest/FarmingContestAPI\n*L\n48#1:173\n100#1:174\n117#1:176\n135#1:178,3\n135#1:181,2\n135#1:184\n141#1:185,3\n141#1:188,2\n141#1:191\n100#1:175\n117#1:177\n135#1:183\n141#1:190\n153#1:192\n153#1:193,2\n159#1:195,2\n159#1:197,4\n169#1:203,4\n58#1:207,2\n169#1:201\n169#1:202\n*E\n"})
public final class FarmingContestAPI {
    @NotNull
    public static final FarmingContestAPI INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern timePattern$delegate;
    @NotNull
    private static final RepoPattern cropPattern$delegate;
    @NotNull
    private static final RepoPattern sidebarCropPattern$delegate;
    @NotNull
    private static final Map<Long, FarmingContest> contests;
    private static boolean internalContest;
    @Nullable
    private static CropType contestCrop;
    private static long startTime;
    private static boolean inInventory;

    private FarmingContestAPI() {
    }

    private final Pattern getTimePattern() {
        return (Pattern)timePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getCropPattern() {
        return (Pattern)cropPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getSidebarCropPattern() {
        return (Pattern)sidebarCropPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getInContest() {
        void $this$isAnyOf$iv;
        if (!internalContest) return false;
        LorenzUtils lorenzUtils = LorenzUtils.INSTANCE;
        Enum enum_ = LorenzUtils.INSTANCE.getSkyBlockIsland();
        IslandType[] islandTypeArray = new IslandType[]{IslandType.GARDEN, IslandType.HUB, IslandType.THE_FARMING_ISLANDS};
        Enum[] array$iv = islandTypeArray;
        boolean $i$f$isAnyOf = false;
        if (!ArraysKt.contains(array$iv, $this$isAnyOf$iv)) return false;
        return true;
    }

    @Nullable
    public final CropType getContestCrop() {
        return contestCrop;
    }

    public final void setContestCrop(@Nullable CropType cropType) {
        contestCrop = cropType;
    }

    public final boolean getInInventory() {
        return inInventory;
    }

    public final void setInInventory(boolean bl) {
        inInventory = bl;
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (internalContest) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(startTime), DurationKt.toDuration(20, DurationUnit.MINUTES)) > 0) {
                CropType cropType = contestCrop;
                Intrinsics.checkNotNull((Object)cropType);
                new FarmingContestEvent(cropType, FarmingContestPhase.STOP).postAndCatch();
                internalContest = false;
            }
        }
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        this.checkActiveContest();
    }

    private final void checkActiveContest() {
        boolean currentContest;
        CropType currentCrop = this.readCurrentCrop();
        boolean bl = currentContest = currentCrop != null;
        if (this.getInContest() != currentContest) {
            if (currentContest) {
                CropType cropType = currentCrop;
                Intrinsics.checkNotNull((Object)cropType);
                new FarmingContestEvent(cropType, FarmingContestPhase.START).postAndCatch();
                startTime = SimpleTimeMark.Companion.now-uFjCsEo();
            } else if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(startTime), DurationKt.toDuration(2, DurationUnit.MINUTES)) > 0) {
                CropType cropType = contestCrop;
                Intrinsics.checkNotNull((Object)cropType);
                new FarmingContestEvent(cropType, FarmingContestPhase.STOP).postAndCatch();
            }
            internalContest = currentContest;
        } else if (currentCrop != contestCrop && currentCrop != null) {
            new FarmingContestEvent(currentCrop, FarmingContestPhase.CHANGE).postAndCatch();
            startTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        contestCrop = currentCrop;
    }

    private final CropType readCurrentCrop() {
        CropType cropType;
        String string2 = CollectionUtils.nextAfter$default(CollectionUtils.INSTANCE, ScoreboardData.INSTANCE.getSidebarLinesFormatted(), "\u00a7eJacob's Contest", 0, 2, null);
        if (string2 == null) {
            return null;
        }
        String line = string2;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getSidebarCropPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(line);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$readCurrentCrop_u24lambda_u241 = it$iv;
            boolean bl2 = false;
            String string3 = $this$readCurrentCrop_u24lambda_u241.group("crop");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            cropType = CropType.Companion.getByName(string3);
        } else {
            cropType = null;
        }
        return cropType;
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (Intrinsics.areEqual(event.getInventoryName(), "Your Contests")) {
            inInventory = true;
        }
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = false;
    }

    @Nullable
    public final List<String> getSbDateFromItemName(@NotNull String text) {
        List<String> list;
        Intrinsics.checkNotNullParameter(text, "text");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getTimePattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$getSbDateFromItemName_u24lambda_u242 = it$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{$this$getSbDateFromItemName_u24lambda_u242.group("year"), $this$getSbDateFromItemName_u24lambda_u242.group("month"), $this$getSbDateFromItemName_u24lambda_u242.group("day")};
            list = CollectionsKt.listOf(stringArray);
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final Long getSbTimeFor(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        List<String> list = this.getSbDateFromItemName(text);
        if (list == null) {
            return null;
        }
        List<String> list2 = list;
        String year = list2.get(0);
        String month = list2.get(1);
        String day = list2.get(2);
        int monthNr = LorenzUtils.INSTANCE.getSBMonthByName(month);
        return new SkyBlockTime(Integer.parseInt(year), monthNr, Integer.parseInt(day), 0, 0, 0, 56, null).toMillis();
    }

    public final void addContest(long time, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        contests.putIfAbsent(time, this.createContest(time, item));
    }

    /*
     * WARNING - void declaration
     */
    private final FarmingContest createContest(long time, ItemStack item) {
        CropType cropType;
        Object it$iv$iv$iv;
        String line$iv$iv$iv;
        Sequence sequence$iv$iv$iv;
        Object $this$firstMatcher$iv$iv;
        Object object;
        List<String> lore;
        block5: {
            void $this$matchFirst$iv;
            void this_$iv$iv;
            void this_$iv;
            lore = ItemUtils.INSTANCE.getLore(item);
            object = RegexUtils.INSTANCE;
            List<String> list = lore;
            Pattern pattern$iv = this.getCropPattern();
            boolean $i$f$matchFirst = false;
            void var11_10 = this_$iv;
            $this$firstMatcher$iv$iv = pattern$iv;
            boolean $i$f$firstMatcher = false;
            void var14_14 = this_$iv$iv;
            Pattern pattern = $this$firstMatcher$iv$iv;
            sequence$iv$iv$iv = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
            boolean $i$f$firstMatcher2 = false;
            Iterator iterator2 = sequence$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void $this$firstMatcher$iv$iv$iv;
                line$iv$iv$iv = (String)iterator2.next();
                it$iv$iv$iv = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv);
                boolean bl = false;
                if (!((Matcher)it$iv$iv$iv).matches()) continue;
                Intrinsics.checkNotNull(it$iv$iv$iv);
                Matcher $this$createContest_u24lambda_u243 = it$iv$iv$iv;
                boolean bl2 = false;
                String string2 = $this$createContest_u24lambda_u243.group("crop");
                Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                cropType = CropType.Companion.getByName(string2);
                break block5;
            }
            cropType = null;
        }
        if (cropType == null) {
            throw new IllegalStateException("Crop not found in lore!".toString());
        }
        CropType crop = cropType;
        Object $this$createContest_u24lambda_u245 = object = MapsKt.createMapBuilder();
        boolean bl = false;
        for (ContestBracket bracket : ContestBracket.getEntries()) {
            Integer n;
            block6: {
                void $this$matchFirst$iv;
                void this_$iv$iv;
                void this_$iv;
                $this$firstMatcher$iv$iv = RegexUtils.INSTANCE;
                List<String> $i$f$firstMatcher = lore;
                Pattern pattern$iv = bracket.getBracketPattern();
                boolean $i$f$matchFirst = false;
                sequence$iv$iv$iv = this_$iv;
                Pattern $this$firstMatcher$iv$iv2 = pattern$iv;
                boolean $i$f$firstMatcher3 = false;
                line$iv$iv$iv = this_$iv$iv;
                it$iv$iv$iv = $this$firstMatcher$iv$iv2;
                Sequence sequence$iv$iv$iv2 = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
                boolean $i$f$firstMatcher4 = false;
                Iterator iterator3 = sequence$iv$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    void $this$firstMatcher$iv$iv$iv;
                    String line$iv$iv$iv2 = (String)iterator3.next();
                    Matcher it$iv$iv$iv2 = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv2);
                    boolean bl3 = false;
                    if (!it$iv$iv$iv2.matches()) continue;
                    Intrinsics.checkNotNull(it$iv$iv$iv2);
                    Matcher $this$createContest_u24lambda_u245_u24lambda_u244 = it$iv$iv$iv2;
                    boolean bl4 = false;
                    String string3 = $this$createContest_u24lambda_u245_u24lambda_u244.group("amount");
                    Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
                    n = NumberUtil.INSTANCE.formatInt(string3);
                    break block6;
                }
                n = null;
            }
            if (n == null) {
                continue;
            }
            int amount = n;
            $this$createContest_u24lambda_u245.put(bracket, amount);
        }
        Map<ContestBracket, Integer> brackets = MapsKt.build(object);
        return new FarmingContest(time, crop, brackets);
    }

    @Nullable
    public final FarmingContest getContestAtTime(long time) {
        return contests.get(time);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FarmingContest> getContestsOfType(@NotNull CropType crop) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)crop, "crop");
        Iterable $this$filter$iv = contests.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FarmingContest it = (FarmingContest)element$iv$iv;
            boolean bl = false;
            if (!(it.getCrop() == crop)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Integer, Map<ContestBracket, Integer>> calculateAverages(@NotNull CropType crop) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Object object2;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)crop, "crop");
        int amount = 0;
        Map crops = new LinkedHashMap();
        Map contests = new LinkedHashMap();
        Iterable iterable = this.getContestsOfType(crop);
        CollectionUtils collectionUtils = CollectionUtils.INSTANCE;
        boolean $i$f$associateWith = false;
        Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Map.Entry $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator2 = $this$associateWithTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object element$iv$iv = iterator2.next();
            FarmingContest farmingContest = (FarmingContest)element$iv$iv;
            object2 = element$iv$iv;
            Map map2 = (Map)result$iv;
            boolean bl = false;
            object = it.getTime();
            map2.put(object2, object);
        }
        for (FarmingContest contest : collectionUtils.sortedDesc((Map)result$iv).keySet()) {
            ++amount;
            Map<ContestBracket, Integer> brackets = contest.getBrackets();
            result$iv = brackets.entrySet().iterator();
            while (result$iv.hasNext()) {
                $this$associateWithTo$iv$iv = (Map.Entry)result$iv.next();
                ContestBracket bracket = (ContestBracket)((Object)$this$associateWithTo$iv$iv.getKey());
                int count2 = ((Number)$this$associateWithTo$iv$iv.getValue()).intValue();
                int old = ((Number)crops.getOrDefault((Object)bracket, 0)).intValue();
                crops.put(bracket, count2 + old);
                CollectionUtils.INSTANCE.addOrPut(contests, bracket, 1);
            }
            if (amount != 10) continue;
        }
        Map map3 = crops;
        object2 = amount;
        boolean $i$f$mapValues = false;
        void brackets = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map4;
            boolean bl3 = false;
            ContestBracket bracket = (ContestBracket)((Object)entry.getKey());
            int counter = ((Number)entry.getValue()).intValue();
            Object v = contests.get((Object)bracket);
            Intrinsics.checkNotNull(v);
            Integer n = counter / ((Number)v).intValue();
            object.put(k, n);
        }
        Map map5 = destination$iv$iv;
        Object object3 = object2;
        return new Pair<Integer, Map<ContestBracket, Integer>>((Integer)object3, map5);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(FarmingContestAPI.class, "timePattern", "getTimePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(FarmingContestAPI.class, "cropPattern", "getCropPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(FarmingContestAPI.class, "sidebarCropPattern", "getSidebarCropPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new FarmingContestAPI();
        patternGroup = RepoPattern.Companion.group("garden.farming.contest");
        timePattern$delegate = patternGroup.pattern("time", "\u00a7a(?<month>.*) (?<day>.*)(?:rd|st|nd|th), Year (?<year>.*)");
        cropPattern$delegate = patternGroup.pattern("crop", "\u00a78(?<crop>.*) Contest");
        sidebarCropPattern$delegate = patternGroup.pattern("sidebarcrop", "\\s*(?:\u00a7e\u25cb|\u00a76\u2618) \u00a7f(?<crop>.*) \u00a7a.*");
        contests = new LinkedHashMap();
        startTime = SimpleTimeMark.Companion.farPast();
        Iterable $this$forEach$iv = ContestBracket.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContestBracket it = (ContestBracket)((Object)element$iv);
            boolean bl = false;
            it.getBracketPattern();
        }
    }
}

