/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.SensitivityReducerConfig;
import at.hannibal2.skyhanni.config.storage.Storage;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.HypixelJoinEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.misc.LockMouseLook;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0012J\r\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u0019\u0010\u0017\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u0019\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0018J\u001f\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020$H\u0007\u00a2\u0006\u0004\b%\u0010&R\u001c\u0010+\u001a\n (*\u0004\u0018\u00010'0'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001c\u0010/\u001a\n (*\u0004\u0018\u00010,0,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0016\u00100\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00101R\u0016\u00104\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b6\u00107R\u001c\u0010;\u001a\n (*\u0004\u0018\u000108088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u001c\u0010=\u001a\n (*\u0004\u0018\u00010<0<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lat/hannibal2/skyhanni/features/garden/SensitivityReducer;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "reloadSensitivity", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "isHoldingTool", "()Z", "isHoldingKey", "isEnabled", "manualToggle", "showMessage", "lowerSensitivity", "(Z)V", "restoreSensitivity", "state", "toggle", "", "input", "reverse", "doTheMath", "(FZ)F", "Lat/hannibal2/skyhanni/events/HypixelJoinEvent;", "onHypixelJoin", "(Lat/hannibal2/skyhanni/events/HypixelJoinEvent;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/SensitivityReducerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/SensitivityReducerConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/Storage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/Storage;", "storage", "isToggled", "Z", "isManualToggle", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastCheckCooldown", "J", "LOCKED", "F", "Lnet/minecraft/client/Minecraft;", "getMc", "()Lnet/minecraft/client/Minecraft;", "mc", "Lnet/minecraft/client/settings/GameSettings;", "gameSettings", "Lnet/minecraft/client/settings/GameSettings;", "1.8.9"})
public final class SensitivityReducer {
    @NotNull
    public static final SensitivityReducer INSTANCE = new SensitivityReducer();
    private static boolean isToggled;
    private static boolean isManualToggle;
    private static long lastCheckCooldown;
    private static final float LOCKED = -0.33333334f;
    private static final GameSettings gameSettings;

    private SensitivityReducer() {
    }

    private final SensitivityReducerConfig getConfig() {
        return SkyHanniMod.feature.garden.sensitivityReducerConfig;
    }

    private final Storage getStorage() {
        return SkyHanniMod.feature.storage;
    }

    private final Minecraft getMc() {
        return Minecraft.func_71410_x();
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            if (isToggled) {
                if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastCheckCooldown), DurationKt.toDuration(1, DurationUnit.SECONDS)) > 0) {
                    lastCheckCooldown = SimpleTimeMark.Companion.now-uFjCsEo();
                    isToggled = false;
                    SensitivityReducer.restoreSensitivity$default(this, false, 1, null);
                }
            }
            return;
        }
        if (isManualToggle) {
            return;
        }
        if (isToggled && ((Boolean)this.getConfig().onGround.get()).booleanValue() && !this.getMc().field_71439_g.field_70122_E) {
            SensitivityReducer.restoreSensitivity$default(this, false, 1, null);
            isToggled = false;
            return;
        }
        SensitivityReducerConfig.Mode mode = this.getConfig().mode;
        switch (mode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                if (isToggled) {
                    this.toggle(false);
                }
                return;
            }
            case 2: {
                if (this.isHoldingTool() && !isToggled) {
                    this.toggle(true);
                    break;
                }
                if (!isToggled || this.isHoldingTool()) break;
                this.toggle(false);
                break;
            }
            case 3: {
                if (this.isHoldingKey() && !isToggled) {
                    this.toggle(true);
                    break;
                }
                if (!isToggled || this.isHoldingKey()) break;
                this.toggle(false);
                break;
            }
            default: {
                return;
            }
        }
        if (isToggled) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastCheckCooldown), DurationKt.toDuration(1, DurationUnit.SECONDS)) > 0) {
                if (GardenAPI.INSTANCE.getOnBarnPlot() && ((Boolean)this.getConfig().onlyPlot.get()).booleanValue()) {
                    isToggled = false;
                    SensitivityReducer.restoreSensitivity$default(this, false, 1, null);
                }
                if (!this.getMc().field_71439_g.field_70122_E && ((Boolean)this.getConfig().onGround.get()).booleanValue()) {
                    isToggled = false;
                    SensitivityReducer.restoreSensitivity$default(this, false, 1, null);
                }
                lastCheckCooldown = SimpleTimeMark.Companion.now-uFjCsEo();
            }
        }
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property<Float> property = this.getConfig().reducingFactor;
        Intrinsics.checkNotNullExpressionValue(property, "reducingFactor");
        ConditionalUtils.INSTANCE.afterChange(property, SensitivityReducer::onConfigLoad$lambda$0);
        Property<Boolean> property2 = this.getConfig().onlyPlot;
        Intrinsics.checkNotNullExpressionValue(property2, "onlyPlot");
        ConditionalUtils.INSTANCE.afterChange(property2, SensitivityReducer::onConfigLoad$lambda$1);
        Property<Boolean> property3 = this.getConfig().onGround;
        Intrinsics.checkNotNullExpressionValue(property3, "onGround");
        ConditionalUtils.INSTANCE.afterChange(property3, SensitivityReducer::onConfigLoad$lambda$2);
    }

    private final void reloadSensitivity() {
        if (isToggled || isManualToggle) {
            SensitivityReducer.restoreSensitivity$default(this, false, 1, null);
            SensitivityReducer.lowerSensitivity$default(this, false, 1, null);
        }
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!isToggled && !isManualToggle) {
            return;
        }
        if (!this.getConfig().showGUI) {
            return;
        }
        if (LockMouseLook.INSTANCE.getLockedMouse()) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, "\u00a7eSensitivity Lowered", 0, 0, "Sensitivity Lowered", 6, null);
    }

    private final boolean isHoldingTool() {
        return GardenAPI.INSTANCE.getToolInHand() != null;
    }

    private final boolean isHoldingKey() {
        return KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().keybind) && this.getMc().field_71462_r == null;
    }

    public final boolean isEnabled() {
        return isToggled || isManualToggle;
    }

    public final void manualToggle() {
        if (isToggled) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "This command is disabled while the Sensitivity is lowered.", false, null, 6, null);
            return;
        }
        boolean bl = isManualToggle = !isManualToggle;
        if (isManualToggle) {
            this.lowerSensitivity(true);
        } else {
            this.restoreSensitivity(true);
        }
    }

    private final void lowerSensitivity(boolean showMessage) {
        Float divisor = (Float)this.getConfig().reducingFactor.get();
        ChatUtils.INSTANCE.debug("dividing by " + divisor);
        if (!LockMouseLook.INSTANCE.getLockedMouse()) {
            Float f = this.getStorage().savedMouseloweredSensitivity = Float.valueOf(SensitivityReducer.gameSettings.field_74341_c);
            Intrinsics.checkNotNullExpressionValue(f, "savedMouseloweredSensitivity");
            float newSens = SensitivityReducer.doTheMath$default(this, ((Number)f).floatValue(), false, 2, null);
            if (gameSettings != null) {
                gameSettings.field_74341_c = newSens;
            }
        } else {
            this.getStorage().savedMouseloweredSensitivity = this.getStorage().savedMouselockedSensitivity;
        }
        if (showMessage) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse sensitivity is now lowered. Type /shsensreduce to restore your sensitivity.", false, null, 6, null);
        }
    }

    static /* synthetic */ void lowerSensitivity$default(SensitivityReducer sensitivityReducer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        sensitivityReducer.lowerSensitivity(bl);
    }

    private final void restoreSensitivity(boolean showMessage) {
        if (!LockMouseLook.INSTANCE.getLockedMouse() && gameSettings != null) {
            gameSettings.field_74341_c = this.getStorage().savedMouseloweredSensitivity.floatValue();
        }
        if (showMessage) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse sensitivity is now restored.", false, null, 6, null);
        }
    }

    static /* synthetic */ void restoreSensitivity$default(SensitivityReducer sensitivityReducer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        sensitivityReducer.restoreSensitivity(bl);
    }

    private final void toggle(boolean state) {
        if (((Boolean)this.getConfig().onlyPlot.get()).booleanValue() && GardenAPI.INSTANCE.getOnBarnPlot()) {
            return;
        }
        if (((Boolean)this.getConfig().onGround.get()).booleanValue() && !this.getMc().field_71439_g.field_70122_E) {
            return;
        }
        if (!isToggled) {
            SensitivityReducer.lowerSensitivity$default(this, false, 1, null);
        } else {
            SensitivityReducer.restoreSensitivity$default(this, false, 1, null);
        }
        isToggled = state;
    }

    public final float doTheMath(float input2, boolean reverse) {
        float f;
        Float divisor = (Float)this.getConfig().reducingFactor.get();
        if (!reverse) {
            Intrinsics.checkNotNull(divisor);
            f = (input2 - -0.33333334f) / divisor.floatValue() + -0.33333334f;
        } else {
            f = divisor.floatValue() * (input2 - -0.33333334f) + -0.33333334f;
        }
        return f;
    }

    public static /* synthetic */ float doTheMath$default(SensitivityReducer sensitivityReducer, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sensitivityReducer.doTheMath(f, bl);
    }

    @SubscribeEvent
    public final void onHypixelJoin(@NotNull HypixelJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Float divisor = (Float)this.getConfig().reducingFactor.get();
        float expectedLoweredSensitivity = this.doTheMath(SensitivityReducer.gameSettings.field_74341_c, true);
        if ((double)Math.abs(this.getStorage().savedMouseloweredSensitivity.floatValue() - expectedLoweredSensitivity) <= 1.0E-4) {
            ChatUtils.INSTANCE.debug("Fixing incorrectly lowered sensitivity");
            isToggled = false;
            isManualToggle = false;
            SensitivityReducer.restoreSensitivity$default(this, false, 1, null);
        }
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Garden Sensitivity Reducer");
        if (!GardenAPI.INSTANCE.inGarden()) {
            event.addIrrelevant("not in garden");
            return;
        }
        if (this.getConfig().mode == SensitivityReducerConfig.Mode.OFF) {
            event.addIrrelevant("disabled in config");
            return;
        }
        event.addData(SensitivityReducer::onDebugDataCollect$lambda$3);
    }

    private static final Unit onConfigLoad$lambda$0(Float $this$afterChange) {
        INSTANCE.reloadSensitivity();
        return Unit.INSTANCE;
    }

    private static final Unit onConfigLoad$lambda$1(Boolean $this$afterChange) {
        if (isToggled && ((Boolean)SensitivityReducer.INSTANCE.getConfig().onlyPlot.get()).booleanValue() && GardenAPI.INSTANCE.getOnBarnPlot()) {
            SensitivityReducer.restoreSensitivity$default(INSTANCE, false, 1, null);
            isToggled = false;
        }
        return Unit.INSTANCE;
    }

    private static final Unit onConfigLoad$lambda$2(Boolean $this$afterChange) {
        if (isToggled && ((Boolean)SensitivityReducer.INSTANCE.getConfig().onGround.get()).booleanValue() && SensitivityReducer.INSTANCE.getMc().field_71439_g.field_70122_E) {
            SensitivityReducer.restoreSensitivity$default(INSTANCE, false, 1, null);
            isToggled = false;
        }
        return Unit.INSTANCE;
    }

    private static final Unit onDebugDataCollect$lambda$3(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("Current Sensitivity: " + SensitivityReducer.gameSettings.field_74341_c);
        $this$addData.add("Stored Sensitivity: " + SensitivityReducer.INSTANCE.getStorage().savedMouseloweredSensitivity);
        $this$addData.add("onGround: " + SensitivityReducer.INSTANCE.getMc().field_71439_g.field_70122_E);
        $this$addData.add("onBarn: " + GardenAPI.INSTANCE.getOnBarnPlot());
        $this$addData.add("enabled: " + (isToggled || isManualToggle));
        $this$addData.add("--- config ---");
        $this$addData.add("mode: " + SensitivityReducer.INSTANCE.getConfig().mode.name());
        $this$addData.add("Current Divisor: " + SensitivityReducer.INSTANCE.getConfig().reducingFactor.get());
        $this$addData.add("Keybind: " + SensitivityReducer.INSTANCE.getConfig().keybind);
        $this$addData.add("onlyGround: " + SensitivityReducer.INSTANCE.getConfig().onGround.get());
        $this$addData.add("onlyPlot: " + SensitivityReducer.INSTANCE.getConfig().onlyPlot.get());
        return Unit.INSTANCE;
    }

    static {
        lastCheckCooldown = SimpleTimeMark.Companion.farPast();
        gameSettings = SensitivityReducer.INSTANCE.getMc().field_71474_y;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SensitivityReducerConfig.Mode.values().length];
            try {
                nArray[SensitivityReducerConfig.Mode.OFF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SensitivityReducerConfig.Mode.TOOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SensitivityReducerConfig.Mode.KEYBIND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

