/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.WidgetUpdateEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropMilestoneDisplay;
import at.hannibal2.skyhanni.features.garden.pests.PestAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001b\u0010$\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001b\u0010'\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010!\u001a\u0004\b&\u0010#R\u001b\u0010*\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010!\u001a\u0004\b)\u0010#R \u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00140.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00061"}, d2={"Lat/hannibal2/skyhanni/features/garden/GardenCropMilestoneFix;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;", "onTabListUpdate", "(Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;)V", "", "cropName", "", "tier", "", "percentage", "check", "(Ljava/lang/String;ID)V", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "", "tabListValue", "source", "minDiff", "changedValue", "(Lat/hannibal2/skyhanni/features/garden/CropType;JLjava/lang/String;I)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "tabListPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTabListPattern", "()Ljava/util/regex/Pattern;", "tabListPattern", "levelUpPattern$delegate", "getLevelUpPattern", "levelUpPattern", "pestRareDropPattern$delegate", "getPestRareDropPattern", "pestRareDropPattern", "", "tabListCropProgress", "Ljava/util/Map;", "", "loadedCrops", "Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGardenCropMilestoneFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenCropMilestoneFix.kt\nat/hannibal2/skyhanni/features/garden/GardenCropMilestoneFix\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n8#2:147\n8#2:149\n8#2:151\n32#2,3:153\n18#2,2:156\n21#2:159\n1#3:148\n1#3:150\n1#3:152\n1#3:158\n*S KotlinDebug\n*F\n+ 1 GardenCropMilestoneFix.kt\nat/hannibal2/skyhanni/features/garden/GardenCropMilestoneFix\n*L\n53#1:147\n62#1:149\n75#1:151\n92#1:153,3\n92#1:156,2\n92#1:159\n53#1:148\n62#1:150\n75#1:152\n92#1:158\n*E\n"})
public final class GardenCropMilestoneFix {
    @NotNull
    public static final GardenCropMilestoneFix INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern tabListPattern$delegate;
    @NotNull
    private static final RepoPattern levelUpPattern$delegate;
    @NotNull
    private static final RepoPattern pestRareDropPattern$delegate;
    @NotNull
    private static final Map<CropType, Long> tabListCropProgress;
    @NotNull
    private static final List<CropType> loadedCrops;

    private GardenCropMilestoneFix() {
    }

    private final Pattern getTabListPattern() {
        return (Pattern)tabListPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getLevelUpPattern() {
        return (Pattern)levelUpPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getPestRareDropPattern() {
        return (Pattern)pestRareDropPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Pattern $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getLevelUpPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            String cropName = $this$onChat_u24lambda_u240.group("crop");
            Intrinsics.checkNotNull(cropName);
            CropType cropType = CropType.Companion.getByNameOrNull(cropName);
            if (cropType == null) {
                return;
            }
            CropType crop = cropType;
            String string2 = $this$onChat_u24lambda_u240.group("tier");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            int tier = NumberUtil.INSTANCE.romanToDecimalIfNecessary(string2);
            long crops = GardenCropMilestones.getCropsForTier$default(GardenCropMilestones.INSTANCE, tier, crop, false, 4, null);
            INSTANCE.changedValue(crop, crops, "level up chat message", 0);
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = PestAPI.INSTANCE.getPestDeathChatPattern();
        text$iv = event.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u241 = it$iv;
            boolean bl3 = false;
            String string3 = $this$onChat_u24lambda_u241.group("amount");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            int amount = Integer.parseInt(string3);
            String string4 = $this$onChat_u24lambda_u241.group("item");
            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
            NEUInternalName nEUInternalName = NEUInternalName.Companion.fromItemNameOrNull(string4);
            if (nEUInternalName == null) {
                return;
            }
            NEUInternalName item = nEUInternalName;
            PrimitiveItemStack primitiveStack = NEUItems.getPrimitiveMultiplier$default(NEUItems.INSTANCE, item, 0, 2, null);
            String rawName = ItemUtils.INSTANCE.getItemNameWithoutColor(primitiveStack.getInternalName());
            CropType cropType = CropType.Companion.getByNameOrNull(rawName);
            if (cropType == null) {
                return;
            }
            CropType cropType2 = cropType;
            GardenCropMilestones.INSTANCE.setCounter(cropType2, GardenCropMilestones.INSTANCE.getCounter(cropType2) + (long)(amount * primitiveStack.getAmount()));
            GardenCropMilestoneDisplay.INSTANCE.update();
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getPestRareDropPattern();
        text$iv = event.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl4 = false;
            String string5 = $this$onChat_u24lambda_u242.group("item");
            Intrinsics.checkNotNullExpressionValue(string5, "group(...)");
            NEUInternalName nEUInternalName = NEUInternalName.Companion.fromItemNameOrNull(string5);
            if (nEUInternalName == null) {
                return;
            }
            NEUInternalName item = nEUInternalName;
            PrimitiveItemStack primitiveStack = NEUItems.getPrimitiveMultiplier$default(NEUItems.INSTANCE, item, 0, 2, null);
            String rawName = ItemUtils.INSTANCE.getItemNameWithoutColor(primitiveStack.getInternalName());
            CropType cropType = CropType.Companion.getByNameOrNull(rawName);
            if (cropType == null) {
                return;
            }
            CropType cropType3 = cropType;
            GardenCropMilestones.INSTANCE.setCounter(cropType3, GardenCropMilestones.INSTANCE.getCounter(cropType3) + (long)primitiveStack.getAmount());
            GardenCropMilestoneDisplay.INSTANCE.update();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTabListUpdate(@NotNull WidgetUpdateEvent event) {
        void $this$matchFirst$iv;
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!event.isWidget(TabWidget.CROP_MILESTONE)) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        List<String> list = event.getLines();
        Pattern pattern$iv = this.getTabListPattern();
        boolean $i$f$matchFirst = false;
        void var6_6 = this_$iv;
        Pattern $this$firstMatcher$iv$iv = pattern$iv;
        boolean $i$f$firstMatcher = false;
        void var9_9 = this_$iv$iv;
        Pattern pattern = $this$firstMatcher$iv$iv;
        Sequence sequence$iv$iv$iv = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
        boolean $i$f$firstMatcher2 = false;
        Iterator iterator2 = sequence$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$firstMatcher$iv$iv$iv;
            String line$iv$iv$iv = (String)iterator2.next();
            Matcher it$iv$iv$iv = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv);
            boolean bl = false;
            if (!it$iv$iv$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv$iv$iv);
            Matcher $this$onTabListUpdate_u24lambda_u243 = it$iv$iv$iv;
            boolean bl2 = false;
            String string2 = $this$onTabListUpdate_u24lambda_u243.group("tier");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            int tier = Integer.parseInt(string2);
            String string3 = $this$onTabListUpdate_u24lambda_u243.group("percentage");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            double percentage = Double.parseDouble(string3);
            String cropName = $this$onTabListUpdate_u24lambda_u243.group("crop");
            Intrinsics.checkNotNull(cropName);
            INSTANCE.check(cropName, tier, percentage);
            break;
        }
    }

    private final void check(String cropName, int tier, double percentage) {
        if (!ProfileStorageData.INSTANCE.getLoaded()) {
            return;
        }
        CropType crop = CropType.Companion.getByNameOrNull(cropName);
        if (crop == null) {
            ChatUtils.INSTANCE.debug("GardenCropMilestoneFix: crop is null: '" + cropName + '\'');
            return;
        }
        long baseCrops = GardenCropMilestones.getCropsForTier$default(GardenCropMilestones.INSTANCE, tier, crop, false, 4, null);
        long next = GardenCropMilestones.getCropsForTier$default(GardenCropMilestones.INSTANCE, tier + 1, crop, false, 4, null);
        long progressCrops = next - baseCrops;
        double progress = (double)progressCrops * (percentage / (double)100);
        double smallestPercentage = (double)progressCrops * 5.0E-4;
        double tabListValue = (double)baseCrops + progress - smallestPercentage;
        long newValue = (long)tabListValue;
        Long l = tabListCropProgress.get((Object)crop);
        long l2 = newValue;
        if ((l == null || l != l2) && tabListCropProgress.containsKey((Object)crop)) {
            this.changedValue(crop, newValue, "tab list", (int)smallestPercentage);
        }
        Long l3 = newValue;
        tabListCropProgress.put(crop, l3);
    }

    private final void changedValue(CropType crop, long tabListValue, String source, int minDiff) {
        long calculated = GardenCropMilestones.INSTANCE.getCounter(crop);
        long diff = calculated - tabListValue;
        if (diff <= (long)(-minDiff)) {
            GardenCropMilestones.INSTANCE.setCounter(crop, tabListValue);
            GardenCropMilestoneDisplay.INSTANCE.update();
            if (!loadedCrops.contains((Object)crop)) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Loaded " + crop.getCropName() + " milestone data from " + source + '!', false, null, 6, null);
                loadedCrops.add(crop);
            }
        } else if (diff >= (long)minDiff) {
            ChatUtils.INSTANCE.debug("Fixed wrong " + crop.getCropName() + " milestone data from " + source + ": " + NumberUtil.INSTANCE.addSeparators(diff));
            GardenCropMilestones.INSTANCE.setCounter(crop, tabListValue);
            GardenCropMilestoneDisplay.INSTANCE.update();
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(GardenCropMilestoneFix.class, "tabListPattern", "getTabListPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(GardenCropMilestoneFix.class, "levelUpPattern", "getLevelUpPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(GardenCropMilestoneFix.class, "pestRareDropPattern", "getPestRareDropPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new GardenCropMilestoneFix();
        patternGroup = RepoPattern.Companion.group("garden.cropmilestone.fix");
        tabListPattern$delegate = patternGroup.pattern("tablist", " (?<crop>Wheat|Carrot|Potato|Pumpkin|Sugar Cane|Melon|Cactus|Cocoa Beans|Mushroom|Nether Wart) (?<tier>\\d+): \u00a7r\u00a7a(?<percentage>.*)%");
        levelUpPattern$delegate = patternGroup.pattern("levelup", " {2}\u00a7r\u00a7b\u00a7lGARDEN MILESTONE \u00a73(?<crop>.*) \u00a78.*\u279c\u00a73(?<tier>.*)");
        pestRareDropPattern$delegate = patternGroup.pattern("pests.raredrop", "\u00a76\u00a7lRARE DROP! (?:\u00a7.)*(?<item>.+) \u00a76\\(\u00a76\\+.*\u2618\\)");
        tabListCropProgress = new LinkedHashMap();
        loadedCrops = new ArrayList();
    }
}

