/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.GardenConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.PetAPI;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.GardenJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.CropClickEvent;
import at.hannibal2.skyhanni.events.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketSentEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityCollectionStats;
import at.hannibal2.skyhanni.features.garden.AnitaMedalProfit;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.composter.ComposterOverlay;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContestAPI;
import at.hannibal2.skyhanni.features.garden.farming.GardenBestCropTime;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.features.garden.fortuneguide.FFGuideGUI;
import at.hannibal2.skyhanni.features.garden.fortuneguide.FarmingItems;
import at.hannibal2.skyhanni.features.garden.inventory.SkyMartCopperPrice;
import at.hannibal2.skyhanni.features.garden.visitor.VisitorAPI;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateShopPrice;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzRarity;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.C09PacketHeldItemChange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u000f\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0003J%\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010!J\r\u0010#\u001a\u00020\u001d\u00a2\u0006\u0004\b#\u0010!J\u0013\u0010$\u001a\u0004\u0018\u00010\u0016*\u00020\u0014\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020\u0014\u00a2\u0006\u0004\b(\u0010)J5\u0010.\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010,\u001a\u00020+2\b\b\u0002\u0010-\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b.\u0010/J3\u00101\u001a\u00020\u0006*\b\u0012\u0004\u0012\u0002000*2\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010,\u001a\u00020+2\b\b\u0002\u0010-\u001a\u00020\u001d\u00a2\u0006\u0004\b1\u0010/J\r\u00102\u001a\u00020\u001d\u00a2\u0006\u0004\b2\u0010!J\r\u00103\u001a\u00020\u0006\u00a2\u0006\u0004\b3\u0010\u0003J\u0017\u00105\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000204H\u0007\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b7\u00108J\u0017\u0010:\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000209H\u0007\u00a2\u0006\u0004\b:\u0010;J\u0015\u0010>\u001a\u00020'2\u0006\u0010=\u001a\u00020<\u00a2\u0006\u0004\b>\u0010?J\u0017\u0010A\u001a\u00020<2\b\b\u0002\u0010@\u001a\u00020\u001d\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010D\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020CH\u0007\u00a2\u0006\u0004\bD\u0010ER$\u0010F\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\b\u0019\u0010H\"\u0004\bI\u0010JR$\u0010K\u001a\u0004\u0018\u00010\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR$\u0010Q\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u00108\"\u0004\bT\u0010UR\u0011\u0010W\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010!R\u0016\u0010X\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bX\u0010YR\u0011\u0010[\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010!R\u0013\u0010_\u001a\u0004\u0018\u00010\\8F\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R\u0019\u0010d\u001a\n a*\u0004\u0018\u00010`0`8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010cR\"\u0010e\u001a\u00020<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\be\u0010f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR(\u0010p\u001a\u0004\u0018\u00010'2\b\u0010k\u001a\u0004\u0018\u00010'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u0014\u0010r\u001a\u00020q8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\br\u0010sR\u001a\u0010u\u001a\b\u0012\u0004\u0012\u00020\u00180t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bu\u0010vR\u0018\u0010x\u001a\u0004\u0018\u00010w8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010yR\u001c\u0010z\u001a\b\u0012\u0004\u0012\u00020<0t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bz\u0010vR\u0014\u0010{\u001a\u00020<8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b{\u0010f\u00a8\u0006|"}, d2={"Lat/hannibal2/skyhanni/features/garden/GardenAPI;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;", "event", "", "onSendPacket", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "updateGardenTool", "checkItemInHand", "Lnet/minecraft/item/ItemStack;", "toolItem", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "", "getToolInHand", "(Lnet/minecraft/item/ItemStack;Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "", "isOtherTool", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Z", "inGarden", "()Z", "isCurrentlyFarming", "hasFarmingToolInHand", "getCropType", "(Lnet/minecraft/item/ItemStack;)Lat/hannibal2/skyhanni/features/garden/CropType;", "itemStack", "", "readCounter", "(Lnet/minecraft/item/ItemStack;)J", "", "", "scale", "highlight", "addCropIcon", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/garden/CropType;DZ)V", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "addCropIconRenderable", "hideExtraGuis", "clearCropSpeed", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "getCurrentlyFarmedCrop", "()Lat/hannibal2/skyhanni/features/garden/CropType;", "Lat/hannibal2/skyhanni/events/BlockClickEvent;", "onBlockClick", "(Lat/hannibal2/skyhanni/events/BlockClickEvent;)V", "", "requestedLevel", "getExpForLevel", "(I)J", "overflow", "getGardenLevel", "(Z)I", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "toolInHand", "Ljava/lang/String;", "()Ljava/lang/String;", "setToolInHand", "(Ljava/lang/String;)V", "itemInHand", "Lnet/minecraft/item/ItemStack;", "getItemInHand", "()Lnet/minecraft/item/ItemStack;", "setItemInHand", "(Lnet/minecraft/item/ItemStack;)V", "cropInHand", "Lat/hannibal2/skyhanni/features/garden/CropType;", "getCropInHand", "setCropInHand", "(Lat/hannibal2/skyhanni/features/garden/CropType;)V", "getMushroomCowPet", "mushroomCowPet", "inBarn", "Z", "getOnBarnPlot", "onBarnPlot", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$GardenStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$GardenStorage;", "storage", "Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "config", "totalAmountVisitorsExisting", "I", "getTotalAmountVisitorsExisting", "()I", "setTotalAmountVisitorsExisting", "(I)V", "value", "getGardenExp", "()Ljava/lang/Long;", "setGardenExp", "(Ljava/lang/Long;)V", "gardenExp", "Lnet/minecraft/util/AxisAlignedBB;", "barnArea", "Lnet/minecraft/util/AxisAlignedBB;", "", "otherToolsList", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "lastLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "gardenExperience", "gardenOverflowExp", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGardenAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenAPI.kt\nat/hannibal2/skyhanni/features/garden/GardenAPI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,286:1\n1#2:287\n295#3,2:288\n12#4,7:290\n*S KotlinDebug\n*F\n+ 1 GardenAPI.kt\nat/hannibal2/skyhanni/features/garden/GardenAPI\n*L\n170#1:288,2\n278#1:290,7\n*E\n"})
public final class GardenAPI {
    @NotNull
    public static final GardenAPI INSTANCE = new GardenAPI();
    @Nullable
    private static String toolInHand;
    @Nullable
    private static ItemStack itemInHand;
    @Nullable
    private static CropType cropInHand;
    private static boolean inBarn;
    private static int totalAmountVisitorsExisting;
    @NotNull
    private static final AxisAlignedBB barnArea;
    @NotNull
    private static final List<String> otherToolsList;
    @Nullable
    private static LorenzVec lastLocation;
    @NotNull
    private static List<Integer> gardenExperience;
    private static final int gardenOverflowExp = 10000;

    private GardenAPI() {
    }

    @Nullable
    public final String getToolInHand() {
        return toolInHand;
    }

    public final void setToolInHand(@Nullable String string2) {
        toolInHand = string2;
    }

    @Nullable
    public final ItemStack getItemInHand() {
        return itemInHand;
    }

    public final void setItemInHand(@Nullable ItemStack itemStack2) {
        itemInHand = itemStack2;
    }

    @Nullable
    public final CropType getCropInHand() {
        return cropInHand;
    }

    public final void setCropInHand(@Nullable CropType cropType) {
        cropInHand = cropType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getMushroomCowPet() {
        if (!PetAPI.INSTANCE.isCurrentPet("Mooshroom Cow")) return false;
        ProfileSpecificStorage.GardenStorage gardenStorage = this.getStorage();
        if (gardenStorage == null) return false;
        ProfileSpecificStorage.GardenStorage.Fortune fortune = gardenStorage.fortune;
        if (fortune == null) return false;
        Map<FarmingItems, ItemStack> map2 = fortune.farmingItems;
        if (map2 == null) return false;
        ItemStack itemStack2 = map2.get((Object)FarmingItems.MOOSHROOM_COW);
        if (itemStack2 == null) return false;
        ItemStack it = itemStack2;
        boolean bl = false;
        LorenzRarity lorenzRarity = ItemUtils.INSTANCE.getItemRarityOrNull(it);
        if (lorenzRarity == null) return false;
        Boolean bl2 = lorenzRarity.isAtLeast(LorenzRarity.RARE);
        Boolean bl3 = bl2;
        if (bl3 == null) return false;
        boolean bl4 = bl3;
        if (!bl4) return false;
        return true;
    }

    public final boolean getOnBarnPlot() {
        return inBarn && this.inGarden();
    }

    @Nullable
    public final ProfileSpecificStorage.GardenStorage getStorage() {
        ProfileSpecificStorage profileSpecificStorage = ProfileStorageData.INSTANCE.getProfileSpecific();
        return profileSpecificStorage != null ? profileSpecificStorage.garden : null;
    }

    public final GardenConfig getConfig() {
        return SkyHanniMod.feature.garden;
    }

    public final int getTotalAmountVisitorsExisting() {
        return totalAmountVisitorsExisting;
    }

    public final void setTotalAmountVisitorsExisting(int n) {
        totalAmountVisitorsExisting = n;
    }

    @Nullable
    public final Long getGardenExp() {
        ProfileSpecificStorage.GardenStorage gardenStorage = this.getStorage();
        return gardenStorage != null ? gardenStorage.experience : null;
    }

    public final void setGardenExp(@Nullable Long value) {
        block1: {
            Long l = value;
            if (l == null) break block1;
            long it = ((Number)l).longValue();
            boolean bl = false;
            if (INSTANCE.getStorage() != null) {
                INSTANCE.getStorage().experience = it;
            }
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onSendPacket(@NotNull PacketSentEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getPacket() instanceof C09PacketHeldItemChange)) {
            return;
        }
        this.checkItemInHand();
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.inGarden()) {
            return;
        }
        this.checkItemInHand();
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(500, DurationUnit.MILLISECONDS), GardenAPI::onInventoryClose$lambda$2);
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.inGarden()) {
            return;
        }
        if (event.isMod(10, 1)) {
            inBarn = LocationUtils.INSTANCE.isPlayerInside(barnArea);
            if (Minecraft.func_71410_x().field_71462_r == null) {
                return;
            }
            this.checkItemInHand();
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(2, DurationUnit.SECONDS), GardenAPI::onWorldChange$lambda$3);
    }

    private final void updateGardenTool() {
        new GardenToolChangeEvent(cropInHand, itemInHand).postAndCatch();
    }

    private final void checkItemInHand() {
        ItemStack toolItem;
        ItemStack itemStack2 = toolItem = InventoryUtils.INSTANCE.getItemInHand();
        CropType crop = itemStack2 != null ? this.getCropType(itemStack2) : null;
        String newTool = this.getToolInHand(toolItem, crop);
        if (!Intrinsics.areEqual(toolInHand, newTool)) {
            toolInHand = newTool;
            cropInHand = crop;
            itemInHand = toolItem;
            this.updateGardenTool();
        }
    }

    private final String getToolInHand(ItemStack toolItem, CropType crop) {
        if (crop != null) {
            return crop.getCropName();
        }
        Object object = toolItem;
        if (object == null || (object = ItemUtils.INSTANCE.getInternalName((ItemStack)object)) == null) {
            return null;
        }
        Object internalName = object;
        return this.isOtherTool((NEUInternalName)internalName) ? ((NEUInternalName)internalName).asString() : null;
    }

    private final boolean isOtherTool(NEUInternalName internalName) {
        return otherToolsList.contains(internalName.asString());
    }

    public final boolean inGarden() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.GARDEN);
    }

    public final boolean isCurrentlyFarming() {
        return this.inGarden() && GardenCropSpeed.INSTANCE.getAverageBlocksPerSecond() > 0.0 && this.hasFarmingToolInHand();
    }

    public final boolean hasFarmingToolInHand() {
        boolean bl;
        ItemStack itemStack2 = InventoryUtils.INSTANCE.getItemInHand();
        if (itemStack2 != null) {
            ItemStack it = itemStack2;
            boolean bl2 = false;
            CropType crop = INSTANCE.getCropType(it);
            bl = INSTANCE.getToolInHand(it, crop) != null;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final CropType getCropType(@NotNull ItemStack $this$getCropType) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$getCropType, "<this>");
            NEUInternalName internalName = ItemUtils.INSTANCE.getInternalName($this$getCropType);
            Iterable $this$firstOrNull$iv = CropType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CropType it = (CropType)((Object)element$iv);
                boolean bl = false;
                if (!internalName.startsWith(it.getToolName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final long readCounter(@NotNull ItemStack itemStack2) {
        long l;
        Intrinsics.checkNotNullParameter(itemStack2, "itemStack");
        Long l2 = SkyBlockItemModifierUtils.INSTANCE.getHoeCounter(itemStack2);
        if (l2 != null) {
            l = l2;
        } else {
            Long l3 = SkyBlockItemModifierUtils.INSTANCE.getCultivatingCounter(itemStack2);
            l = l3 != null ? l3 : -1L;
        }
        return l;
    }

    @Deprecated(message="use renderable list instead", replaceWith=@ReplaceWith(expression="", imports={}))
    public final void addCropIcon(@NotNull List<Object> $this$addCropIcon, @NotNull CropType crop, double scale, boolean highlight) {
        Intrinsics.checkNotNullParameter($this$addCropIcon, "<this>");
        Intrinsics.checkNotNullParameter((Object)crop, "crop");
        ItemStack itemStack2 = crop.getIcon().func_77946_l();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "copy(...)");
        RenderUtils.INSTANCE.addItemIcon($this$addCropIcon, itemStack2, highlight, scale);
    }

    public static /* synthetic */ void addCropIcon$default(GardenAPI gardenAPI, List list, CropType cropType, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.6666666666666666;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        gardenAPI.addCropIcon(list, cropType, d, bl);
    }

    public final void addCropIconRenderable(@NotNull List<Renderable> $this$addCropIconRenderable, @NotNull CropType crop, double scale, boolean highlight) {
        Intrinsics.checkNotNullParameter($this$addCropIconRenderable, "<this>");
        Intrinsics.checkNotNullParameter((Object)crop, "crop");
        ItemStack itemStack2 = crop.getIcon().func_77946_l();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "copy(...)");
        CollectionUtils.INSTANCE.addItemStack($this$addCropIconRenderable, itemStack2, highlight, scale);
    }

    public static /* synthetic */ void addCropIconRenderable$default(GardenAPI gardenAPI, List list, CropType cropType, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.6666666666666666;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        gardenAPI.addCropIconRenderable(list, cropType, d, bl);
    }

    public final boolean hideExtraGuis() {
        return ComposterOverlay.INSTANCE.getInInventory() || AnitaMedalProfit.INSTANCE.getInInventory() || SkyMartCopperPrice.INSTANCE.getInInventory() || FarmingContestAPI.INSTANCE.getInInventory() || VisitorAPI.INSTANCE.getInInventory() || FFGuideGUI.Companion.isInGui() || ChocolateShopPrice.INSTANCE.getInInventory() || ChocolateFactoryAPI.INSTANCE.getInChocolateFactory() || ChocolateFactoryAPI.INSTANCE.getChocolateFactoryPaused() || HoppityCollectionStats.INSTANCE.getInInventory();
    }

    public final void clearCropSpeed() {
        Object object = this.getStorage();
        if (object != null && (object = ((ProfileSpecificStorage.GardenStorage)object).cropsPerSecond) != null) {
            object.clear();
        }
        GardenBestCropTime.INSTANCE.reset();
        this.updateGardenTool();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Manually reset all crop speed data!", false, null, 6, null);
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        GardenBestCropTime.INSTANCE.reset();
    }

    @Nullable
    public final CropType getCurrentlyFarmedCrop() {
        CropType brokenCrop = toolInHand != null ? GardenCropSpeed.INSTANCE.getLastBrokenCrop() : null;
        CropType cropType = cropInHand;
        if (cropType == null) {
            cropType = brokenCrop;
        }
        return cropType;
    }

    @SubscribeEvent
    public final void onBlockClick(@NotNull BlockClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.inGarden()) {
            return;
        }
        IBlockState blockState = event.getGetBlockState();
        CropType cropType = CropType.Companion.getCropType(blockState);
        if (cropType == null) {
            return;
        }
        CropType cropBroken = cropType;
        if (cropBroken.getMultiplier() == 1 && BlockUtils.INSTANCE.isBabyCrop(blockState)) {
            return;
        }
        LorenzVec position = event.getPosition();
        if (Intrinsics.areEqual(lastLocation, position)) {
            return;
        }
        lastLocation = position;
        new CropClickEvent(position, cropBroken, blockState, event.getClickType(), event.getItemInHand()).postAndCatch();
    }

    public final long getExpForLevel(int requestedLevel) {
        long totalExp = 0L;
        int tier = 0;
        Iterator<Integer> iterator2 = gardenExperience.iterator();
        while (iterator2.hasNext()) {
            int tierExp = ((Number)iterator2.next()).intValue();
            totalExp += (long)tierExp;
            if (++tier != requestedLevel) continue;
            return totalExp;
        }
        while (tier < requestedLevel) {
            totalExp += (long)10000;
            if (++tier != requestedLevel) continue;
            return totalExp;
        }
        return 0L;
    }

    public final int getGardenLevel(boolean overflow) {
        Long l = this.getGardenExp();
        if (l == null) {
            return 0;
        }
        long gardenExp = l;
        int tier = 0;
        long totalExp = 0L;
        Iterator<Integer> iterator2 = gardenExperience.iterator();
        while (iterator2.hasNext()) {
            int tierExp = ((Number)iterator2.next()).intValue();
            if ((totalExp += (long)tierExp) > gardenExp) {
                return tier;
            }
            ++tier;
        }
        if (overflow) {
            totalExp += (long)10000;
            while (totalExp < gardenExp) {
                ++tier;
                totalExp += (long)10000;
            }
        }
        return tier;
    }

    public static /* synthetic */ int getGardenLevel$default(GardenAPI gardenAPI, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return gardenAPI.getGardenLevel(bl);
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        GardenJson gardenJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "Garden";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            gardenJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, GardenJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        GardenJson data2 = gardenJson;
        gardenExperience = data2.getGardenExp();
        totalAmountVisitorsExisting = data2.getVisitors().size();
    }

    private static final Unit onInventoryClose$lambda$2() {
        if (INSTANCE.inGarden()) {
            INSTANCE.checkItemInHand();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onWorldChange$lambda$3() {
        if (INSTANCE.inGarden()) {
            INSTANCE.checkItemInHand();
        }
        return Unit.INSTANCE;
    }

    static {
        barnArea = new AxisAlignedBB(35.5, 70.0, -4.5, -32.5, 100.0, -46.5);
        String[] stringArray = new String[]{"DAEDALUS_AXE", "STARRED_DAEDALUS_AXE", "BASIC_GARDENING_HOE", "ADVANCED_GARDENING_AXE", "BASIC_GARDENING_AXE", "ADVANCED_GARDENING_HOE", "ROOKIE_HOE", "BINGHOE"};
        otherToolsList = CollectionsKt.listOf(stringArray);
        gardenExperience = CollectionsKt.emptyList();
    }
}

