/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.fishing.FishingHookDisplayConfig;
import at.hannibal2.skyhanni.events.CheckRenderEntityEvent;
import at.hannibal2.skyhanni.events.FishingBobberCastEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.entity.EntityEnterWorldEvent;
import at.hannibal2.skyhanni.features.fishing.FishingAPI;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u001d\u0010\u0012\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001b\u001a\u00020\u001a*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001c\u0010#\u001a\n  *\u0004\u0018\u00010\u001f0\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010$\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingHookDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/FishingBobberCastEvent;", "onBobberThrow", "(Lat/hannibal2/skyhanni/events/FishingBobberCastEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "reset", "Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;", "Lnet/minecraft/entity/item/EntityArmorStand;", "onJoinWorld", "(Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;)V", "Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;", "onCheckRender", "(Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "hasCorrectName", "(Lnet/minecraft/entity/item/EntityArmorStand;)Z", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/fishing/FishingHookDisplayConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/FishingHookDisplayConfig;", "config", "armorStand", "Lnet/minecraft/entity/item/EntityArmorStand;", "", "potentialArmorStands", "Ljava/util/List;", "Ljava/util/regex/Pattern;", "pattern", "Ljava/util/regex/Pattern;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFishingHookDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingHookDisplay.kt\nat/hannibal2/skyhanni/features/fishing/FishingHookDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n774#2:93\n865#2,2:94\n*S KotlinDebug\n*F\n+ 1 FishingHookDisplay.kt\nat/hannibal2/skyhanni/features/fishing/FishingHookDisplay\n*L\n40#1:93\n40#1:94,2\n*E\n"})
public final class FishingHookDisplay {
    @NotNull
    public static final FishingHookDisplay INSTANCE = new FishingHookDisplay();
    @Nullable
    private static EntityArmorStand armorStand;
    @NotNull
    private static final List<EntityArmorStand> potentialArmorStands;
    @NotNull
    private static final Pattern pattern;

    private FishingHookDisplay() {
    }

    private final FishingHookDisplayConfig getConfig() {
        return SkyHanniMod.feature.fishing.fishingHookDisplay;
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.reset();
    }

    @SubscribeEvent
    public final void onBobberThrow(@NotNull FishingBobberCastEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (armorStand == null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = potentialArmorStands;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EntityArmorStand it = (EntityArmorStand)element$iv$iv;
                boolean bl = false;
                if (!(it.func_145818_k_() && INSTANCE.hasCorrectName(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filter2 = (List)destination$iv$iv;
            if (filter2.size() == 1) {
                armorStand = (EntityArmorStand)filter2.get(0);
            }
        }
    }

    private final void reset() {
        potentialArmorStands.clear();
        armorStand = null;
    }

    @HandleEvent
    public final void onJoinWorld(@NotNull EntityEnterWorldEvent<EntityArmorStand> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        potentialArmorStands.add(event.getEntity());
    }

    @SubscribeEvent
    public final void onCheckRender(@NotNull CheckRenderEntityEvent<?> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().hideArmorStand) {
            return;
        }
        if (Intrinsics.areEqual(event.getEntity(), armorStand)) {
            event.cancel();
        }
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        EntityArmorStand entityArmorStand = armorStand;
        if (entityArmorStand == null) {
            return;
        }
        EntityArmorStand armorStand = entityArmorStand;
        if (armorStand.field_70128_L) {
            this.reset();
            return;
        }
        if (!armorStand.func_145818_k_()) {
            return;
        }
        if (Intrinsics.areEqual(armorStand.func_70005_c_(), "\u00a7c\u00a7l!!!")) {
            String string3 = this.getConfig().customAlertText;
            Intrinsics.checkNotNullExpressionValue(string3, "customAlertText");
            string2 = StringsKt.replace$default(string3, "&", "\u00a7", false, 4, null);
        } else {
            string2 = armorStand.func_70005_c_();
        }
        String alertText = string2;
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, alertText, 0, 0, "Fishing Hook Display", 6, null);
    }

    private final boolean hasCorrectName(EntityArmorStand $this$hasCorrectName) {
        if (Intrinsics.areEqual($this$hasCorrectName.func_70005_c_(), "\u00a7c\u00a7l!!!")) {
            return true;
        }
        return pattern.matcher($this$hasCorrectName.func_70005_c_()).matches();
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled && FishingAPI.INSTANCE.getHoldingRod();
    }

    static {
        potentialArmorStands = new ArrayList();
        String string2 = "\u00a7e\u00a7l(\\d+(\\.\\d+)?)";
        int n = 0;
        Pattern pattern = Pattern.compile(string2, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        FishingHookDisplay.pattern = pattern;
    }
}

