/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.lobby.waypoints.christmas;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.event.waypoints.ChristmasPresentConfig;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.WinterAPI;
import at.hannibal2.skyhanni.data.jsonobjects.repo.EventWaypointsJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.features.event.lobby.waypoints.EventWaypoint;
import at.hannibal2.skyhanni.features.event.lobby.waypoints.EventWaypointKt;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010#\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ9\u0010#\u001a\u00020\u0006*\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b#\u0010$J\u0013\u0010%\u001a\u00020\u001e*\u00020\u0011H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020'H\u0007\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b*\u0010+R\u001c\u00100\u001a\n -*\u0004\u0018\u00010,0,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R(\u00103\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001102018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R(\u00105\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001102018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00104R\u0018\u00106\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u001c\u0010:\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001c\u0010<\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00109R\u0014\u0010>\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u001b\u0010E\u001a\u00020@8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\bC\u0010DR\u001b\u0010H\u001a\u00020@8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010B\u001a\u0004\bG\u0010DR\u001b\u0010K\u001a\u00020@8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010B\u001a\u0004\bJ\u0010D\u00a8\u0006L"}, d2={"Lat/hannibal2/skyhanni/features/event/lobby/waypoints/christmas/PresentWaypoints;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "", "message", "processChatMessage", "(Ljava/lang/String;)V", "handlePresentFound", "Lat/hannibal2/skyhanni/features/event/lobby/waypoints/EventWaypoint;", "present", "markEntranceAsFound", "(Lat/hannibal2/skyhanni/features/event/lobby/waypoints/EventWaypoint;)V", "handleAllPresentsFound", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "", "waypoints", "", "shouldDraw", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "color", "prefix", "drawWaypoints", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;Ljava/util/Set;ZLat/hannibal2/skyhanni/utils/LorenzColor;Ljava/lang/String;)V", "shouldShow", "(Lat/hannibal2/skyhanni/features/event/lobby/waypoints/EventWaypoint;)Z", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/event/waypoints/ChristmasPresentConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/waypoints/ChristmasPresentConfig;", "config", "", "", "presentLocations", "Ljava/util/Map;", "presentEntranceLocations", "closest", "Lat/hannibal2/skyhanni/features/event/lobby/waypoints/EventWaypoint;", "getPresentSet", "()Ljava/util/Set;", "presentSet", "getPresentEntranceSet", "presentEntranceSet", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "presentAlreadyFoundPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getPresentAlreadyFoundPattern", "()Ljava/util/regex/Pattern;", "presentAlreadyFoundPattern", "presentFoundPattern$delegate", "getPresentFoundPattern", "presentFoundPattern", "allFoundPattern$delegate", "getAllFoundPattern", "allFoundPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPresentWaypoints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PresentWaypoints.kt\nat/hannibal2/skyhanni/features/event/lobby/waypoints/christmas/PresentWaypoints\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,130:1\n2341#2,14:131\n827#2:146\n855#2,2:147\n2341#2,14:149\n1#3:145\n12#4,7:163\n*S KotlinDebug\n*F\n+ 1 PresentWaypoints.kt\nat/hannibal2/skyhanni/features/event/lobby/waypoints/christmas/PresentWaypoints\n*L\n72#1:131,14\n95#1:146\n95#1:147,2\n97#1:149,14\n122#1:163,7\n*E\n"})
public final class PresentWaypoints {
    @NotNull
    public static final PresentWaypoints INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static Map<String, ? extends Set<EventWaypoint>> presentLocations;
    @NotNull
    private static Map<String, ? extends Set<EventWaypoint>> presentEntranceLocations;
    @Nullable
    private static EventWaypoint closest;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern presentAlreadyFoundPattern$delegate;
    @NotNull
    private static final RepoPattern presentFoundPattern$delegate;
    @NotNull
    private static final RepoPattern allFoundPattern$delegate;

    private PresentWaypoints() {
    }

    private final ChristmasPresentConfig getConfig() {
        return SkyHanniMod.feature.event.lobbyWaypoints.christmasPresent;
    }

    private final Set<EventWaypoint> getPresentSet() {
        return presentLocations.get(HypixelData.INSTANCE.getLobbyType());
    }

    private final Set<EventWaypoint> getPresentEntranceSet() {
        return presentEntranceLocations.get(HypixelData.INSTANCE.getLobbyType());
    }

    private final Pattern getPresentAlreadyFoundPattern() {
        return (Pattern)presentAlreadyFoundPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getPresentFoundPattern() {
        return (Pattern)presentFoundPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getAllFoundPattern() {
        return (Pattern)allFoundPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        closest = null;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        this.processChatMessage(event.getMessage());
    }

    private final void processChatMessage(String message) {
        if (RegexUtils.INSTANCE.matches(this.getPresentFoundPattern(), message) || RegexUtils.INSTANCE.matches(this.getPresentAlreadyFoundPattern(), message)) {
            this.handlePresentFound();
        } else if (RegexUtils.INSTANCE.matches(this.getAllFoundPattern(), message)) {
            this.handleAllPresentsFound();
        }
    }

    private final void handlePresentFound() {
        block7: {
            Object v1;
            Set<EventWaypoint> set = this.getPresentSet();
            if (set == null) break block7;
            Iterable $this$minByOrNull$iv = set;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    EventWaypoint it = (EventWaypoint)minElem$iv;
                    boolean bl = false;
                    double minValue$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it.getPosition());
                    do {
                        Object e$iv = iterator$iv.next();
                        EventWaypoint it2 = (EventWaypoint)e$iv;
                        $i$a$-minByOrNull-PresentWaypoints$handlePresentFound$1 = false;
                        double v$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it2.getPosition());
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            if ((set = (EventWaypoint)v1) != null) {
                Set<EventWaypoint> present = set;
                boolean bl = false;
                ((EventWaypoint)((Object)present)).setFound(true);
                INSTANCE.markEntranceAsFound((EventWaypoint)((Object)present));
                if (Intrinsics.areEqual(closest, present)) {
                    closest = null;
                }
            }
        }
    }

    private final void markEntranceAsFound(EventWaypoint present) {
        block3: {
            Object v1;
            Set<EventWaypoint> set;
            block2: {
                set = this.getPresentEntranceSet();
                if (set == null) break block3;
                Iterable iterable = set;
                for (Object t : iterable) {
                    EventWaypoint it = (EventWaypoint)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(present.getName(), it.getName())) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            if ((set = (EventWaypoint)v1) != null) {
                Set<EventWaypoint> it = set;
                boolean bl = false;
                ((EventWaypoint)((Object)it)).setFound(true);
            }
        }
    }

    private final void handleAllPresentsFound() {
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Congratulations! As all presents are found, we are disabling the Christmas Present Waypoints feature.", false, null, 6, null);
        this.getConfig().allWaypoints = false;
        this.getConfig().allEntranceWaypoints = false;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Object object;
        block14: {
            block13: {
                Object v5;
                List notFoundPresents;
                List list;
                Intrinsics.checkNotNullParameter((Object)event, "event");
                if (!this.isEnabled() && this.getConfig().onlyClosest && HypixelData.INSTANCE.getLocrawData() != null && closest == null) {
                    return;
                }
                Set<EventWaypoint> set = this.getPresentSet();
                if (set != null) {
                    void $this$filterNotTo$iv$iv;
                    Iterable $this$filterNot$iv = set;
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        EventWaypoint it = (EventWaypoint)element$iv$iv;
                        boolean bl = false;
                        if (it.isFound()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = null;
                }
                List list2 = notFoundPresents = list;
                boolean bl = list2 != null ? list2.isEmpty() : false;
                if (bl) {
                    return;
                }
                object = notFoundPresents;
                if (object == null) break block13;
                Iterable $this$minByOrNull$iv = (Iterable)object;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v5 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v5 = minElem$iv;
                    } else {
                        EventWaypoint it = (EventWaypoint)minElem$iv;
                        boolean bl2 = false;
                        double minValue$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it.getPosition());
                        do {
                            Object e$iv = iterator$iv.next();
                            EventWaypoint it2 = (EventWaypoint)e$iv;
                            $i$a$-minByOrNull-PresentWaypoints$onTick$1 = false;
                            double v$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it2.getPosition());
                            if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v5 = minElem$iv;
                    }
                }
                if ((object = (EventWaypoint)v5) != null) break block14;
            }
            return;
        }
        closest = object;
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        block2: {
            Set<EventWaypoint> it;
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            Set<EventWaypoint> set = this.getPresentSet();
            if (set != null) {
                it = set;
                boolean bl = false;
                INSTANCE.drawWaypoints(event, it, PresentWaypoints.INSTANCE.getConfig().allWaypoints, LorenzColor.GOLD, "\u00a76");
            }
            Set<EventWaypoint> set2 = this.getPresentEntranceSet();
            if (set2 == null) break block2;
            it = set2;
            boolean bl = false;
            INSTANCE.drawWaypoints(event, it, PresentWaypoints.INSTANCE.getConfig().allEntranceWaypoints, LorenzColor.YELLOW, "\u00a7e");
        }
    }

    private final void drawWaypoints(LorenzRenderWorldEvent $this$drawWaypoints, Set<EventWaypoint> waypoints, boolean shouldDraw, LorenzColor color, String prefix) {
        if (!shouldDraw) {
            return;
        }
        for (EventWaypoint waypoint : waypoints) {
            if (!this.shouldShow(waypoint)) continue;
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, $this$drawWaypoints, waypoint.getPosition(), color.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, $this$drawWaypoints, waypoint.getPosition(), prefix + waypoint.getName(), 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    private final boolean shouldShow(EventWaypoint $this$shouldShow) {
        return !$this$shouldShow.isFound() && (!this.getConfig().onlyClosest || Intrinsics.areEqual(closest, $this$shouldShow));
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        EventWaypointsJson eventWaypointsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "EventWaypoints";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            eventWaypointsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, EventWaypointsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        EventWaypointsJson data2 = eventWaypointsJson;
        presentLocations = EventWaypointKt.loadEventWaypoints(data2.getPresents());
        presentEntranceLocations = EventWaypointKt.loadEventWaypoints(data2.getPresentsEntrances());
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInHypixelLobby() && (this.getConfig().allWaypoints || this.getConfig().allEntranceWaypoints) && WinterAPI.INSTANCE.isDecember();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PresentWaypoints.class, "presentAlreadyFoundPattern", "getPresentAlreadyFoundPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PresentWaypoints.class, "presentFoundPattern", "getPresentFoundPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PresentWaypoints.class, "allFoundPattern", "getAllFoundPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new PresentWaypoints();
        presentLocations = MapsKt.emptyMap();
        presentEntranceLocations = MapsKt.emptyMap();
        patternGroup = RepoPattern.Companion.group("event.lobby.waypoint.presents");
        presentAlreadyFoundPattern$delegate = patternGroup.pattern("foundalready", "\u00a7cYou have already found this present!");
        presentFoundPattern$delegate = patternGroup.pattern("found", "\u00a7aYou found a.*present! \u00a7r\u00a7e\\(\u00a7r\u00a7b\\d+\u00a7r\u00a7e/\u00a7r\u00a7b\\d+\u00a7r\u00a7e\\)");
        allFoundPattern$delegate = patternGroup.pattern("foundall", "\u00a7aCongratulations! You found all the presents in every lobby!");
    }
}

