/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.config.features.event.hoppity.HoppityEggsConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityAPI;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockTime;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0003R\u001c\u0010!\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R$\u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020%8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020%0,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00061"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityNpc;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "onInventoryUpdated", "(Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "", "isHighlightEnabled", "()Z", "isReminderEnabled", "clear", "Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityEggsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityEggsConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastReminderSent", "J", "", "value", "getHoppityYearOpened", "()I", "setHoppityYearOpened", "(I)V", "hoppityYearOpened", "", "slotsToHighlight", "Ljava/util/Set;", "inShop", "Z", "1.8.9"})
public final class HoppityNpc {
    @NotNull
    public static final HoppityNpc INSTANCE = new HoppityNpc();
    private static long lastReminderSent = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static Set<Integer> slotsToHighlight = new LinkedHashSet();
    private static boolean inShop;

    private HoppityNpc() {
    }

    private final HoppityEggsConfig getConfig() {
        return HoppityEggsManager.INSTANCE.getConfig();
    }

    private final int getHoppityYearOpened() {
        Object object = ChocolateFactoryAPI.INSTANCE.getProfileStorage();
        return object != null && (object = ((ProfileSpecificStorage.ChocolateFactoryStorage)object).hoppityShopYearOpened) != null ? (Integer)object : -1;
    }

    private final void setHoppityYearOpened(int value) {
        block0: {
            if (ChocolateFactoryAPI.INSTANCE.getProfileStorage() == null) break block0;
            ChocolateFactoryAPI.INSTANCE.getProfileStorage().hoppityShopYearOpened = value;
        }
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!Intrinsics.areEqual(event.getInventoryName(), "Hoppity")) {
            return;
        }
        this.setHoppityYearOpened(SkyBlockTime.Companion.now().getYear());
        inShop = true;
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isReminderEnabled()) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        if (this.getHoppityYearOpened() == SkyBlockTime.Companion.now().getYear()) {
            return;
        }
        if (!HoppityAPI.INSTANCE.isHoppityEvent()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastReminderSent), DurationKt.toDuration(2, DurationUnit.MINUTES)) <= 0) {
            return;
        }
        ChatUtils.INSTANCE.clickToActionOrDisable("New rabbits are available at \u00a7aHoppity's Shop\u00a7e!", new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((HoppityEggsConfig)this.receiver).hoppityShopReminder;
            }

            public void set(Object value) {
                ((HoppityEggsConfig)this.receiver).hoppityShopReminder = (Boolean)value;
            }
        }, "warp to hub", HoppityNpc::onSecondPassed$lambda$0);
        lastReminderSent = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.clear();
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.clear();
    }

    @SubscribeEvent
    public final void onInventoryUpdated(@NotNull InventoryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!inShop) {
            return;
        }
        slotsToHighlight.clear();
        for (Map.Entry<Integer, ItemStack> entry : event.getInventoryItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack item = entry.getValue();
            if (!ItemUtils.INSTANCE.getLore(item).contains("\u00a7eClick to trade!")) continue;
            slotsToHighlight.add(slot);
        }
    }

    @SubscribeEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isHighlightEnabled()) {
            return;
        }
        if (!inShop) {
            return;
        }
        for (Slot slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
            if (!slotsToHighlight.contains(slot.getSlotIndex())) continue;
            RenderUtils.INSTANCE.highlight(slot, LorenzColor.GREEN.addOpacity(200));
        }
    }

    private final boolean isHighlightEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().highlightHoppityShop;
    }

    private final boolean isReminderEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().hoppityShopReminder;
    }

    private final void clear() {
        inShop = false;
        slotsToHighlight.clear();
    }

    private static final Unit onSecondPassed$lambda$0() {
        HypixelCommands.INSTANCE.warp("hub");
        return Unit.INSTANCE;
    }
}

