/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.diana;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.event.diana.DianaConfig;
import at.hannibal2.skyhanni.data.TitleManager;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzKeyPressEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.features.event.diana.DianaAPI;
import at.hannibal2.skyhanni.features.event.diana.GriffinBurrowHelper;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001d\u0010\u0003R\u001c\u0010\"\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R$\u0010#\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0018\u0010,\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010$\u00a8\u0006."}, d2={"Lat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzKeyPressEvent;", "event", "", "onKeyClick", "(Lat/hannibal2/skyhanni/events/LorenzKeyPressEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "target", "", "", "debug", "shouldUseWarps", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/util/List;)V", "location", "Lat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper$WarpPoint;", "getNearestWarpPoint", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper$WarpPoint;", "resetDisabledWarps", "Lat/hannibal2/skyhanni/config/features/event/diana/DianaConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/diana/DianaConfig;", "config", "currentWarp", "Lat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper$WarpPoint;", "getCurrentWarp", "()Lat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper$WarpPoint;", "setCurrentWarp", "(Lat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper$WarpPoint;)V", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastWarpTime", "J", "lastWarp", "WarpPoint", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nBurrowWarpHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BurrowWarpHelper.kt\nat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n774#2:147\n865#2,2:148\n1557#2:150\n1628#2,3:151\n1863#2,2:154\n*S KotlinDebug\n*F\n+ 1 BurrowWarpHelper.kt\nat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper\n*L\n118#1:147\n118#1:148,2\n118#1:150\n118#1:151,3\n122#1:154,2\n*E\n"})
public final class BurrowWarpHelper {
    @NotNull
    public static final BurrowWarpHelper INSTANCE = new BurrowWarpHelper();
    @Nullable
    private static WarpPoint currentWarp;
    private static long lastWarpTime;
    @Nullable
    private static WarpPoint lastWarp;

    private BurrowWarpHelper() {
    }

    private final DianaConfig getConfig() {
        return SkyHanniMod.feature.event.diana;
    }

    @Nullable
    public final WarpPoint getCurrentWarp() {
        return currentWarp;
    }

    public final void setCurrentWarp(@Nullable WarpPoint warpPoint) {
        currentWarp = warpPoint;
    }

    @SubscribeEvent
    public final void onKeyClick(@NotNull LorenzKeyPressEvent event) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!DianaAPI.INSTANCE.isDoingDiana()) {
                return;
            }
            if (!this.getConfig().burrowNearestWarp) {
                return;
            }
            if (event.getKeyCode() != this.getConfig().keyBindWarp) {
                return;
            }
            if (Minecraft.func_71410_x().field_71462_r != null) {
                return;
            }
            WarpPoint warpPoint = currentWarp;
            if (warpPoint == null) break block5;
            WarpPoint it = warpPoint;
            boolean bl = false;
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastWarpTime), DurationKt.toDuration(5, DurationUnit.SECONDS)) > 0) {
                lastWarpTime = SimpleTimeMark.Companion.now-uFjCsEo();
                HypixelCommands.INSTANCE.warp(it.name());
                lastWarp = currentWarp;
                GriffinBurrowHelper.INSTANCE.setLastTitleSentTime-gJLAdNM(SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(2, DurationUnit.SECONDS)));
                TitleManager.INSTANCE.optionalResetTitle(BurrowWarpHelper::onKeyClick$lambda$1$lambda$0);
            }
        }
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
                return;
            }
            if (!Intrinsics.areEqual(event.getMessage(), "\u00a7cYou haven't unlocked this fast travel destination!")) break block3;
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastWarpTime), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
                WarpPoint warpPoint = lastWarp;
                if (warpPoint != null) {
                    WarpPoint it = warpPoint;
                    boolean bl = false;
                    it.setUnlocked(false);
                    ChatUtils.chat$default(ChatUtils.INSTANCE, "Detected not having access to warp point \u00a7b" + it.getDisplayName() + "\u00a7e!", false, null, 6, null);
                    ChatUtils.chat$default(ChatUtils.INSTANCE, "Use \u00a7c/shresetburrowwarps \u00a7eonce you have activated this travel scroll.", false, null, 6, null);
                    lastWarp = null;
                    currentWarp = null;
                }
            }
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastWarp = null;
        currentWarp = null;
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Diana Burrow Nearest Warp");
        if (!DianaAPI.INSTANCE.isDoingDiana()) {
            event.addIrrelevant("not doing diana");
            return;
        }
        if (!this.getConfig().burrowNearestWarp) {
            event.addIrrelevant("disabled in config");
            return;
        }
        LorenzVec target = GriffinBurrowHelper.INSTANCE.getTargetLocation();
        if (target == null) {
            event.addIrrelevant("targetLocation is null");
            return;
        }
        List list = new ArrayList();
        this.shouldUseWarps(target, list);
        event.addData(list);
    }

    public final void shouldUseWarps(@NotNull LorenzVec target, @Nullable List<String> debug) {
        Intrinsics.checkNotNullParameter(target, "target");
        List<String> list = debug;
        if (list != null) {
            list.add("target: " + LorenzVec.printWithAccuracy$default(target, 1, null, 2, null));
        }
        LorenzVec playerLocation = LocationUtils.INSTANCE.playerLocation();
        List<String> list2 = debug;
        if (list2 != null) {
            list2.add("playerLocation: " + LorenzVec.printWithAccuracy$default(playerLocation, 1, null, 2, null));
        }
        WarpPoint warpPoint = this.getNearestWarpPoint(target);
        List<String> list3 = debug;
        if (list3 != null) {
            list3.add("warpPoint: " + warpPoint.getDisplayName());
        }
        double playerDistance = playerLocation.distance(target);
        List<String> list4 = debug;
        if (list4 != null) {
            list4.add("playerDistance: " + NumberUtil.INSTANCE.roundTo(playerDistance, 1));
        }
        double warpDistance = warpPoint.distance(target);
        List<String> list5 = debug;
        if (list5 != null) {
            list5.add("warpDistance: " + NumberUtil.INSTANCE.roundTo(warpDistance, 1));
        }
        double difference = playerDistance - warpDistance;
        List<String> list6 = debug;
        if (list6 != null) {
            list6.add("difference: " + NumberUtil.INSTANCE.roundTo(difference, 1));
        }
        boolean setWarpPoint = difference > 10.0;
        List<String> list7 = debug;
        if (list7 != null) {
            list7.add("setWarpPoint: " + setWarpPoint);
        }
        currentWarp = setWarpPoint ? warpPoint : null;
    }

    public static /* synthetic */ void shouldUseWarps$default(BurrowWarpHelper burrowWarpHelper, LorenzVec lorenzVec, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        burrowWarpHelper.shouldUseWarps(lorenzVec, list);
    }

    /*
     * WARNING - void declaration
     */
    private final WarpPoint getNearestWarpPoint(LorenzVec location) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        WarpPoint it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = WarpPoint.getEntries();
        CollectionUtils collectionUtils = CollectionUtils.INSTANCE;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WarpPoint)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it.getUnlocked() && it.getIgnored().invoke() == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WarpPoint)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it, it.distance(location)));
        }
        return (WarpPoint)((Object)CollectionsKt.first(collectionUtils.sorted((List)destination$iv$iv)).getFirst());
    }

    public final void resetDisabledWarps() {
        Iterable $this$forEach$iv = WarpPoint.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WarpPoint it = (WarpPoint)((Object)element$iv);
            boolean bl = false;
            it.setUnlocked(true);
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Reset disabled burrow warps.", false, null, 6, null);
    }

    private static final boolean onKeyClick$lambda$1$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.startsWith$default(it, "\u00a7bWarp to ", false, 2, null);
    }

    static {
        lastWarpTime = SimpleTimeMark.Companion.farPast();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0019\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B;\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0018R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u000b\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'\u00a8\u0006("}, d2={"Lat/hannibal2/skyhanni/features/event/diana/BurrowWarpHelper$WarpPoint;", "", "", "displayName", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "", "extraBlocks", "Lkotlin/Function0;", "", "ignored", "unlocked", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lat/hannibal2/skyhanni/utils/LorenzVec;ILkotlin/jvm/functions/Function0;Z)V", "other", "", "distance", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getLocation", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "I", "Lkotlin/jvm/functions/Function0;", "getIgnored", "()Lkotlin/jvm/functions/Function0;", "Z", "getUnlocked", "()Z", "setUnlocked", "(Z)V", "HUB", "CASTLE", "CRYPT", "DA", "MUSEUM", "WIZARD", "STONKS", "1.8.9"})
    public static final class WarpPoint
    extends Enum<WarpPoint> {
        @NotNull
        private final String displayName;
        @NotNull
        private final LorenzVec location;
        private final int extraBlocks;
        @NotNull
        private final Function0<Boolean> ignored;
        private boolean unlocked;
        public static final /* enum */ WarpPoint HUB = new WarpPoint("HUB", 0, "Hub", new LorenzVec(-3, 70, -70), 2, null, false, 24, null);
        public static final /* enum */ WarpPoint CASTLE = new WarpPoint("CASTLE", 1, "Castle", new LorenzVec(-250, 130, 45), 10, null, false, 24, null);
        public static final /* enum */ WarpPoint CRYPT = new WarpPoint("CRYPT", 2, "Crypt", new LorenzVec(-190, 74, -88), 15, WarpPoint::_init_$lambda$1, false, 16, null);
        public static final /* enum */ WarpPoint DA = new WarpPoint("DA", 3, "Dark Auction", new LorenzVec(91, 74, 173), 2, null, false, 24, null);
        public static final /* enum */ WarpPoint MUSEUM = new WarpPoint("MUSEUM", 4, "Museum", new LorenzVec(-75, 76, 81), 2, null, false, 24, null);
        public static final /* enum */ WarpPoint WIZARD = new WarpPoint("WIZARD", 5, "Wizard", new LorenzVec(42.5, 122.0, 69.0), 5, WarpPoint::_init_$lambda$2, false, 16, null);
        public static final /* enum */ WarpPoint STONKS = new WarpPoint("STONKS", 6, "Stonks", new LorenzVec(-52.5, 70.0, -49.5), 5, WarpPoint::_init_$lambda$3, false, 16, null);
        private static final /* synthetic */ WarpPoint[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private WarpPoint(String displayName, LorenzVec location, int extraBlocks, Function0<Boolean> ignored, boolean unlocked) {
            this.displayName = displayName;
            this.location = location;
            this.extraBlocks = extraBlocks;
            this.ignored = ignored;
            this.unlocked = unlocked;
        }

        /* synthetic */ WarpPoint(String string2, int n, String string3, LorenzVec lorenzVec, int n2, Function0 function0, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                function0 = WarpPoint::_init_$lambda$0;
            }
            if ((n3 & 0x10) != 0) {
                bl = true;
            }
            this(string3, lorenzVec, n2, function0, bl);
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final LorenzVec getLocation() {
            return this.location;
        }

        @NotNull
        public final Function0<Boolean> getIgnored() {
            return this.ignored;
        }

        public final boolean getUnlocked() {
            return this.unlocked;
        }

        public final void setUnlocked(boolean bl) {
            this.unlocked = bl;
        }

        public final double distance(@NotNull LorenzVec other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return other.distance(this.location) + (double)this.extraBlocks;
        }

        public static WarpPoint[] values() {
            return (WarpPoint[])$VALUES.clone();
        }

        public static WarpPoint valueOf(String value) {
            return Enum.valueOf(WarpPoint.class, value);
        }

        @NotNull
        public static EnumEntries<WarpPoint> getEntries() {
            return $ENTRIES;
        }

        private static final boolean _init_$lambda$0() {
            return false;
        }

        private static final boolean _init_$lambda$1() {
            return ((BurrowWarpHelper)BurrowWarpHelper.INSTANCE).getConfig().ignoredWarps.crypt;
        }

        private static final boolean _init_$lambda$2() {
            return ((BurrowWarpHelper)BurrowWarpHelper.INSTANCE).getConfig().ignoredWarps.wizard;
        }

        private static final boolean _init_$lambda$3() {
            return ((BurrowWarpHelper)BurrowWarpHelper.INSTANCE).getConfig().ignoredWarps.stonks;
        }

        static {
            $VALUES = warpPointArray = new WarpPoint[]{WarpPoint.HUB, WarpPoint.CASTLE, WarpPoint.CRYPT, WarpPoint.DA, WarpPoint.MUSEUM, WarpPoint.WIZARD, WarpPoint.STONKS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

