/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.dungeon.SecretChimeConfig;
import at.hannibal2.skyhanni.data.ClickedBlockType;
import at.hannibal2.skyhanni.events.DungeonBlockClickEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.utils.SoundUtils;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\u0003R\u001c\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonSecretChime;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/DungeonBlockClickEvent;", "event", "", "onDungeonClickedBlock", "(Lat/hannibal2/skyhanni/events/DungeonBlockClickEvent;)V", "", "isEnabled", "()Z", "playSound", "Lat/hannibal2/skyhanni/config/features/dungeon/SecretChimeConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/SecretChimeConfig;", "config", "1.8.9"})
public final class DungeonSecretChime {
    @NotNull
    public static final DungeonSecretChime INSTANCE = new DungeonSecretChime();

    private DungeonSecretChime() {
    }

    private final SecretChimeConfig getConfig() {
        return SkyHanniMod.feature.dungeon.secretChime;
    }

    @HandleEvent
    public final void onDungeonClickedBlock(@NotNull DungeonBlockClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        boolean isWaterRoom = Intrinsics.areEqual(DungeonAPI.INSTANCE.getRoomID(), "-60,-60");
        if (isWaterRoom && event.getBlockType() == ClickedBlockType.LEVER) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[event.getBlockType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                DungeonSecretChime.playSound();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean isEnabled() {
        return !DungeonAPI.INSTANCE.getInBossRoom() && DungeonAPI.INSTANCE.inDungeon() && this.getConfig().enabled;
    }

    @JvmStatic
    public static final void playSound() {
        SecretChimeConfig $this$playSound_u24lambda_u240 = INSTANCE.getConfig();
        boolean bl = false;
        String string2 = $this$playSound_u24lambda_u240.soundName;
        Intrinsics.checkNotNullExpressionValue(string2, "soundName");
        SoundUtils.INSTANCE.playSound(SoundUtils.INSTANCE.createSound(string2, $this$playSound_u24lambda_u240.soundPitch, 100.0f));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickedBlockType.values().length];
            try {
                nArray[ClickedBlockType.CHEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.TRAPPED_CHEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.LEVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.WITHER_ESSENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

