/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.dungeon.HighlightClickedBlocksConfig;
import at.hannibal2.skyhanni.data.ClickedBlockType;
import at.hannibal2.skyhanni.events.DungeonBlockClickEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.ExtendedChatColor;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.TimeLimitedCache;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002:;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001c\u0010!\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001b\u0010*\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u001b\u0010-\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010'\u001a\u0004\b,\u0010)R \u00101\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00104\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\u0004068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\u0004068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00108\u00a8\u0006<"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "getRandomColor", "()Lat/hannibal2/skyhanni/utils/LorenzColor;", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/DungeonBlockClickEvent;", "onDungeonClickedBlock", "(Lat/hannibal2/skyhanni/events/DungeonBlockClickEvent;)V", "Lat/hannibal2/skyhanni/data/ClickedBlockType;", "type", "Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$BlockProperties;", "getBlockProperties", "(Lat/hannibal2/skyhanni/data/ClickedBlockType;)Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$BlockProperties;", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onWorldRender", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/dungeon/HighlightClickedBlocksConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/HighlightClickedBlocksConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "leverPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getLeverPattern", "()Ljava/util/regex/Pattern;", "leverPattern", "lockedPattern$delegate", "getLockedPattern", "lockedPattern", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$ClickedBlock;", "blocks", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "", "colorIndex", "I", "", "undesirableColors", "Ljava/util/List;", "randomColors", "ClickedBlock", "BlockProperties", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDungeonHighlightClickedBlocks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonHighlightClickedBlocks.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n528#2,7:117\n1863#2,2:124\n774#2:126\n865#2,2:127\n*S KotlinDebug\n*F\n+ 1 DungeonHighlightClickedBlocks.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks\n*L\n66#1:117,7\n97#1:124,2\n48#1:126\n48#1:127,2\n*E\n"})
public final class DungeonHighlightClickedBlocks {
    @NotNull
    public static final DungeonHighlightClickedBlocks INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern leverPattern$delegate;
    @NotNull
    private static final RepoPattern lockedPattern$delegate;
    @NotNull
    private static final TimeLimitedCache<LorenzVec, ClickedBlock> blocks;
    private static int colorIndex;
    @NotNull
    private static final List<LorenzColor> undesirableColors;
    @NotNull
    private static final List<LorenzColor> randomColors;

    private DungeonHighlightClickedBlocks() {
    }

    private final HighlightClickedBlocksConfig getConfig() {
        return SkyHanniMod.feature.dungeon.clickedBlocks;
    }

    private final Pattern getLeverPattern() {
        return (Pattern)leverPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getLockedPattern() {
        return (Pattern)lockedPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final LorenzColor getRandomColor() {
        int id = colorIndex + 1;
        if (id == randomColors.size()) {
            id = 0;
        }
        colorIndex = id;
        return randomColors.get(colorIndex);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            if (RegexUtils.INSTANCE.matches(this.getLeverPattern(), event.getMessage())) {
                event.setBlockedReason("dungeon_highlight_clicked_block");
            }
            if (!RegexUtils.INSTANCE.matches(this.getLockedPattern(), event.getMessage())) break block4;
            Iterable $this$lastOrNull$iv = blocks;
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)((ClickedBlock)it.getValue()).getDisplayText(), "Chest", false, 2, null)) continue;
                last$iv = element$iv;
            }
            Object object = last$iv;
            if (object != null && (object = (ClickedBlock)object.getValue()) != null) {
                String string2 = this.getConfig().lockedChestColor;
                Intrinsics.checkNotNullExpressionValue(string2, "lockedChestColor");
                ((ClickedBlock)object).setColor(ColorUtils.INSTANCE.toChromaColor(string2));
            }
        }
    }

    @HandleEvent
    public final void onDungeonClickedBlock(@NotNull DungeonBlockClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        boolean isWaterRoom = Intrinsics.areEqual(DungeonAPI.INSTANCE.getRoomID(), "-60,-60");
        if (isWaterRoom && event.getBlockType() == ClickedBlockType.LEVER) {
            return;
        }
        ClickedBlockType type2 = event.getBlockType();
        Color color = this.getConfig().randomColor ? this.getRandomColor().toColor() : ColorUtils.INSTANCE.toChromaColor(this.getBlockProperties(type2).getColor());
        String displayText = new ExtendedChatColor(color.getRGB(), false) + "Clicked " + this.getBlockProperties(type2).getName();
        blocks.set(event.getPosition(), new ClickedBlock(displayText, color));
    }

    private final BlockProperties getBlockProperties(ClickedBlockType type2) {
        BlockProperties blockProperties;
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                String string2 = this.getConfig().leverColor;
                Intrinsics.checkNotNullExpressionValue(string2, "leverColor");
                blockProperties = new BlockProperties("Lever", string2);
                break;
            }
            case 2: {
                String string3 = this.getConfig().chestColor;
                Intrinsics.checkNotNullExpressionValue(string3, "chestColor");
                blockProperties = new BlockProperties("Chest", string3);
                break;
            }
            case 3: {
                String string4 = this.getConfig().trappedChestColor;
                Intrinsics.checkNotNullExpressionValue(string4, "trappedChestColor");
                blockProperties = new BlockProperties("Trapped Chest", string4);
                break;
            }
            case 4: {
                String string5 = this.getConfig().witherEssenceColor;
                Intrinsics.checkNotNullExpressionValue(string5, "witherEssenceColor");
                blockProperties = new BlockProperties("Wither Essence", string5);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return blockProperties;
    }

    @SubscribeEvent
    public final void onWorldRender(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = blocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            LorenzVec position = (LorenzVec)entry.getKey();
            ClickedBlock block = (ClickedBlock)entry.getValue();
            RenderUtils.drawColor$default(RenderUtils.INSTANCE, event, position, block.getColor(), false, 0.0f, 12, null);
            if (!DungeonHighlightClickedBlocks.INSTANCE.getConfig().showText) continue;
            RenderUtils.drawString$default(RenderUtils.INSTANCE, event, position.add(0.5, 0.5, 0.5), block.getDisplayText(), true, null, 8, null);
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 56, "dungeon.highlightClickedBlocks", "dungeon.clickedBlocks.enabled", null, 8, null);
    }

    public final boolean isEnabled() {
        return !DungeonAPI.INSTANCE.getInBossRoom() && DungeonAPI.INSTANCE.inDungeon() && this.getConfig().enabled;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DungeonHighlightClickedBlocks.class, "leverPattern", "getLeverPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(DungeonHighlightClickedBlocks.class, "lockedPattern", "getLockedPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = objectArray;
        INSTANCE = new DungeonHighlightClickedBlocks();
        patternGroup = RepoPattern.Companion.group("dungeons.highlightclickedblock");
        leverPattern$delegate = patternGroup.pattern("lever", "\u00a7cYou hear the sound of something opening...");
        lockedPattern$delegate = patternGroup.pattern("locked", "\u00a7cThat chest is locked!");
        blocks = new TimeLimitedCache(DurationKt.toDuration(3, DurationUnit.SECONDS), null, 2, null);
        objectArray = new LorenzColor[]{LorenzColor.BLACK, LorenzColor.WHITE, LorenzColor.CHROMA, LorenzColor.GRAY, LorenzColor.DARK_GRAY};
        undesirableColors = CollectionsKt.listOf(objectArray);
        Iterable $this$filter$iv = LorenzColor.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LorenzColor it = (LorenzColor)((Object)element$iv$iv);
            boolean bl = false;
            if (!(!undesirableColors.contains((Object)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        randomColors = (List)var3_3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$BlockProperties;", "", "", "name", "color", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "getColor", "1.8.9"})
    public static final class BlockProperties {
        @NotNull
        private final String name;
        @NotNull
        private final String color;

        public BlockProperties(@NotNull String name2, @NotNull String color) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(color, "color");
            this.name = name2;
            this.color = color;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getColor() {
            return this.color;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$ClickedBlock;", "", "", "displayText", "Ljava/awt/Color;", "color", "<init>", "(Ljava/lang/String;Ljava/awt/Color;)V", "Ljava/lang/String;", "getDisplayText", "()Ljava/lang/String;", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "1.8.9"})
    public static final class ClickedBlock {
        @NotNull
        private final String displayText;
        @NotNull
        private Color color;

        public ClickedBlock(@NotNull String displayText, @NotNull Color color) {
            Intrinsics.checkNotNullParameter(displayText, "displayText");
            Intrinsics.checkNotNullParameter(color, "color");
            this.displayText = displayText;
            this.color = color;
        }

        @NotNull
        public final String getDisplayText() {
            return this.displayText;
        }

        @NotNull
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "<set-?>");
            this.color = color;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickedBlockType.values().length];
            try {
                nArray[ClickedBlockType.LEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.CHEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.TRAPPED_CHEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.WITHER_ESSENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

