/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.ClickedBlockType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.ScoreboardData;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.DungeonBlockClickEvent;
import at.hannibal2.skyhanni.events.DungeonBossRoomEnterEvent;
import at.hannibal2.skyhanni.events.DungeonCompleteEvent;
import at.hannibal2.skyhanni.events.DungeonEnterEvent;
import at.hannibal2.skyhanni.events.DungeonStartEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.TablistFooterUpdateEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonFloor;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TabListData;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003}~\u007fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\n\u001a\u00020\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0015\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020$H\u0007\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020'H\u0007\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020*H\u0007\u00a2\u0006\u0004\b+\u0010,J?\u00103\u001a\u00020\r2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190-2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002000/2\u0006\u00102\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b3\u00104J7\u00105\u001a\u00020\r2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190-2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002000/H\u0002\u00a2\u0006\u0004\b5\u00106J\u0017\u00108\u001a\u00020\r2\u0006\u0010\u001e\u001a\u000207H\u0007\u00a2\u0006\u0004\b8\u00109J\u0017\u0010;\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020:H\u0007\u00a2\u0006\u0004\b;\u0010<R\u0014\u0010>\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010A\u001a\u00020@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0014\u0010C\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010?R\u0014\u0010D\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010?R\u0014\u0010E\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010?R\u0014\u0010F\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010?R$\u0010G\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010\u0014\"\u0004\bJ\u0010\u000fR\"\u0010K\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010\u0006\"\u0004\bN\u0010OR\"\u0010P\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010L\u001a\u0004\bQ\u0010\u0006\"\u0004\bR\u0010OR\"\u0010S\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010L\u001a\u0004\bT\u0010\u0006\"\u0004\bU\u0010OR$\u0010W\u001a\u0004\u0018\u00010V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\"\u0010]\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b]\u0010^\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR\"\u0010c\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bc\u0010L\u001a\u0004\bc\u0010\u0006\"\u0004\bd\u0010OR\u001f\u0010g\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0019\u0018\u00010-8F\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0014\u0010i\u001a\u00020h8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u0014\u0010k\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bk\u0010HR\u001b\u0010p\u001a\u00020=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bl\u0010m\u001a\u0004\bn\u0010oR\u001b\u0010s\u001a\u00020=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bq\u0010m\u001a\u0004\br\u0010oR\u001b\u0010v\u001a\u00020=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u0010m\u001a\u0004\bu\u0010oR\u001b\u0010y\u001a\u00020=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bw\u0010m\u001a\u0004\bx\u0010oR\u001b\u0010|\u001a\u00020=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bz\u0010m\u001a\u0004\b{\u0010o\u00a8\u0006\u0080\u0001"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI;", "", "<init>", "()V", "", "inDungeon", "()Z", "", "", "floors", "isOneOf", "([Ljava/lang/String;)Z", "rawMessage", "", "handleBossMessage", "(Ljava/lang/String;)V", "bossName", "checkBossName", "(Ljava/lang/String;)Z", "getTime", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/features/dungeon/DungeonFloor;", "getCurrentBoss", "()Lat/hannibal2/skyhanni/features/dungeon/DungeonFloor;", "getRoomID", "", "level", "getColor", "(I)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/TablistFooterUpdateEvent;", "onTabUpdate", "(Lat/hannibal2/skyhanni/events/TablistFooterUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "", "bossCollections", "", "Lnet/minecraft/item/ItemStack;", "inventoryItems", "inventoryName", "readOneMaxCollection", "(Ljava/util/Map;Ljava/util/Map;Ljava/lang/String;)V", "readAllCollections", "(Ljava/util/Map;Ljava/util/Map;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/BlockClickEvent;", "onBlockClick", "(Lat/hannibal2/skyhanni/events/BlockClickEvent;)V", "Ljava/util/regex/Pattern;", "floorPattern", "Ljava/util/regex/Pattern;", "Lkotlin/text/Regex;", "uniqueClassBonus", "Lkotlin/text/Regex;", "bossPattern", "levelPattern", "killPattern", "totalKillsPattern", "dungeonFloor", "Ljava/lang/String;", "getDungeonFloor", "setDungeonFloor", "started", "Z", "getStarted", "setStarted", "(Z)V", "completed", "getCompleted", "setCompleted", "inBossRoom", "getInBossRoom", "setInBossRoom", "Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonClass;", "playerClass", "Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonClass;", "getPlayerClass", "()Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonClass;", "setPlayerClass", "(Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonClass;)V", "playerClassLevel", "I", "getPlayerClassLevel", "()I", "setPlayerClassLevel", "(I)V", "isUniqueClass", "setUniqueClass", "getBossStorage", "()Ljava/util/Map;", "bossStorage", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "WITHER_ESSENCE_TEXTURE", "timePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTimePattern", "()Ljava/util/regex/Pattern;", "timePattern", "dungeonComplete$delegate", "getDungeonComplete", "dungeonComplete", "dungeonRoomPattern$delegate", "getDungeonRoomPattern", "dungeonRoomPattern", "blessingPattern$delegate", "getBlessingPattern", "blessingPattern", "noBlessingPattern$delegate", "getNoBlessingPattern", "noBlessingPattern", "DungeonBlessings", "DungeonClass", "DungeonChest", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDungeonAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonAPI.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonAPI\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n32#2,3:387\n18#2,2:390\n21#2:393\n32#2,3:394\n18#2,2:397\n21#2:400\n32#2,3:401\n18#2,2:404\n21#2:407\n8#2:410\n8#2:412\n8#2:415\n8#2:417\n8#2:419\n1#3:392\n1#3:399\n1#3:406\n1#3:411\n1#3:413\n1#3:414\n1#3:416\n1#3:418\n1#3:420\n295#4,2:408\n1863#4,2:421\n*S KotlinDebug\n*F\n+ 1 DungeonAPI.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonAPI\n*L\n145#1:387,3\n145#1:390,2\n145#1:393\n154#1:394,3\n154#1:397,2\n154#1:400\n175#1:401,3\n175#1:404,2\n175#1:407\n239#1:410\n247#1:412\n279#1:415\n298#1:417\n303#1:419\n145#1:392\n154#1:399\n175#1:406\n239#1:411\n247#1:413\n279#1:416\n298#1:418\n303#1:420\n182#1:408,2\n335#1:421,2\n*E\n"})
public final class DungeonAPI {
    @NotNull
    public static final DungeonAPI INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final Pattern floorPattern;
    @NotNull
    private static final Regex uniqueClassBonus;
    @NotNull
    private static final Pattern bossPattern;
    @NotNull
    private static final Pattern levelPattern;
    @NotNull
    private static final Pattern killPattern;
    @NotNull
    private static final Pattern totalKillsPattern;
    @Nullable
    private static String dungeonFloor;
    private static boolean started;
    private static boolean completed;
    private static boolean inBossRoom;
    @Nullable
    private static DungeonClass playerClass;
    private static int playerClassLevel;
    private static boolean isUniqueClass;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final String WITHER_ESSENCE_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzRkYjRhZGZhOWJmNDhmZjVkNDE3MDdhZTM0ZWE3OGJkMjM3MTY1OWZjZDhjZDg5MzQ3NDlhZjRjY2U5YiJ9fX0=";
    @NotNull
    private static final RepoPattern timePattern$delegate;
    @NotNull
    private static final RepoPattern dungeonComplete$delegate;
    @NotNull
    private static final RepoPattern dungeonRoomPattern$delegate;
    @NotNull
    private static final RepoPattern blessingPattern$delegate;
    @NotNull
    private static final RepoPattern noBlessingPattern$delegate;

    private DungeonAPI() {
    }

    @Nullable
    public final String getDungeonFloor() {
        return dungeonFloor;
    }

    public final void setDungeonFloor(@Nullable String string2) {
        dungeonFloor = string2;
    }

    public final boolean getStarted() {
        return started;
    }

    public final void setStarted(boolean bl) {
        started = bl;
    }

    public final boolean getCompleted() {
        return completed;
    }

    public final void setCompleted(boolean bl) {
        completed = bl;
    }

    public final boolean getInBossRoom() {
        return inBossRoom;
    }

    public final void setInBossRoom(boolean bl) {
        inBossRoom = bl;
    }

    @Nullable
    public final DungeonClass getPlayerClass() {
        return playerClass;
    }

    public final void setPlayerClass(@Nullable DungeonClass dungeonClass) {
        playerClass = dungeonClass;
    }

    public final int getPlayerClassLevel() {
        return playerClassLevel;
    }

    public final void setPlayerClassLevel(int n) {
        playerClassLevel = n;
    }

    public final boolean isUniqueClass() {
        return isUniqueClass;
    }

    public final void setUniqueClass(boolean bl) {
        isUniqueClass = bl;
    }

    @Nullable
    public final Map<DungeonFloor, Integer> getBossStorage() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        return object != null && (object = ((ProfileSpecificStorage)object).dungeons) != null ? ((ProfileSpecificStorage.DungeonStorage)object).bosses : null;
    }

    private final Pattern getTimePattern() {
        return (Pattern)timePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getDungeonComplete() {
        return (Pattern)dungeonComplete$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getDungeonRoomPattern() {
        return (Pattern)dungeonRoomPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getBlessingPattern() {
        return (Pattern)blessingPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final Pattern getNoBlessingPattern() {
        return (Pattern)noBlessingPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4]);
    }

    public final boolean inDungeon() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.CATACOMBS);
    }

    public final boolean isOneOf(String ... floors) {
        Intrinsics.checkNotNullParameter(floors, "floors");
        String string2 = dungeonFloor;
        return string2 != null ? CollectionUtils.equalsOneOf(string2, Arrays.copyOf(floors, floors.length)) : false;
    }

    public final void handleBossMessage(@NotNull String rawMessage) {
        Intrinsics.checkNotNullParameter(rawMessage, "rawMessage");
        if (!this.inDungeon()) {
            return;
        }
        String message = StringUtils.removeColor$default(StringUtils.INSTANCE, rawMessage, false, 1, null);
        String bossName = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default(StringsKt.substringAfter$default(message, "[BOSS] ", null, 2, null), ":", null, 2, null))).toString();
        if (!Intrinsics.areEqual(bossName, "The Watcher") && dungeonFloor != null && this.checkBossName(bossName) && !inBossRoom) {
            new DungeonBossRoomEnterEvent().postAndCatch();
            inBossRoom = true;
        }
    }

    private final boolean checkBossName(String bossName) {
        String string2;
        String string3 = dungeonFloor;
        Intrinsics.checkNotNull(string3);
        switch (string3) {
            case "E": {
                string2 = "The Watcher";
                break;
            }
            case "M1": 
            case "F1": {
                string2 = "Bonzo";
                break;
            }
            case "M2": 
            case "F2": {
                string2 = "Scarf";
                break;
            }
            case "M3": 
            case "F3": {
                string2 = "The Professor";
                break;
            }
            case "M4": 
            case "F4": {
                string2 = "Thorn";
                break;
            }
            case "M5": 
            case "F5": {
                string2 = "Livid";
                break;
            }
            case "M6": 
            case "F6": {
                string2 = "Sadan";
                break;
            }
            case "M7": 
            case "F7": {
                string2 = "Maxor";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 == null) {
            return false;
        }
        String correctBoss = string2;
        return StringsKt.endsWith$default(bossName, correctBoss, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getTime() {
        String string2;
        block3: {
            void $this$matchFirst$iv;
            void this_$iv$iv;
            void this_$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            List<String> list = ScoreboardData.INSTANCE.getSidebarLinesFormatted();
            Pattern pattern$iv = this.getTimePattern();
            boolean $i$f$matchFirst = false;
            void var5_5 = this_$iv;
            Pattern $this$firstMatcher$iv$iv = pattern$iv;
            boolean $i$f$firstMatcher = false;
            void var8_8 = this_$iv$iv;
            Pattern pattern = $this$firstMatcher$iv$iv;
            Sequence sequence$iv$iv$iv = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
            boolean $i$f$firstMatcher2 = false;
            Iterator iterator2 = sequence$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void $this$firstMatcher$iv$iv$iv;
                String line$iv$iv$iv = (String)iterator2.next();
                Matcher it$iv$iv$iv = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv);
                boolean bl = false;
                if (!it$iv$iv$iv.matches()) continue;
                Intrinsics.checkNotNull(it$iv$iv$iv);
                Matcher $this$getTime_u24lambda_u240 = it$iv$iv$iv;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = RegexUtils.INSTANCE.groupOrNull($this$getTime_u24lambda_u240, "minutes");
                if (string3 == null) {
                    string3 = "00";
                }
                string2 = stringBuilder.append(string3).append(':').append($this$getTime_u24lambda_u240.group("seconds")).toString();
                break block3;
            }
            string2 = null;
        }
        String string4 = string2;
        if (string2 == null) {
            string4 = "";
        }
        return string4;
    }

    @Nullable
    public final DungeonFloor getCurrentBoss() {
        String string2 = dungeonFloor;
        if (string2 == null) {
            return null;
        }
        String floor = string2;
        return DungeonFloor.valueOf(StringsKt.replace$default(floor, "M", "F", false, 4, null));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getRoomID() {
        String string2;
        block1: {
            void $this$matchFirst$iv;
            void this_$iv$iv;
            void this_$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            List<String> list = ScoreboardData.INSTANCE.getSidebarLinesFormatted();
            Pattern pattern$iv = this.getDungeonRoomPattern();
            boolean $i$f$matchFirst = false;
            void var5_5 = this_$iv;
            Pattern $this$firstMatcher$iv$iv = pattern$iv;
            boolean $i$f$firstMatcher = false;
            void var8_8 = this_$iv$iv;
            Pattern pattern = $this$firstMatcher$iv$iv;
            Sequence sequence$iv$iv$iv = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
            boolean $i$f$firstMatcher2 = false;
            Iterator iterator2 = sequence$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void $this$firstMatcher$iv$iv$iv;
                String line$iv$iv$iv = (String)iterator2.next();
                Matcher it$iv$iv$iv = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv);
                boolean bl = false;
                if (!it$iv$iv$iv.matches()) continue;
                Intrinsics.checkNotNull(it$iv$iv$iv);
                Matcher $this$getRoomID_u24lambda_u241 = it$iv$iv$iv;
                boolean bl2 = false;
                string2 = $this$getRoomID_u24lambda_u241.group("roomId");
                break block1;
            }
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final String getColor(int level) {
        return level >= 50 ? "\u00a7c\u00a7l" : (level >= 45 ? "\u00a7c" : (level >= 40 ? "\u00a76" : (level >= 35 ? "\u00a7d" : (level >= 30 ? "\u00a79" : (level >= 25 ? "\u00a7b" : (level >= 20 ? "\u00a72" : (level >= 15 ? "\u00a7a" : (level >= 10 ? "\u00a7e" : (level >= 5 ? "\u00a7f" : "\u00a77")))))))));
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Object[] objectArray;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (dungeonFloor == null) {
            void $this$matchFirst$iv;
            void this_$iv$iv;
            void this_$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            iterator2 = ScoreboardData.INSTANCE.getSidebarLinesFormatted();
            Pattern pattern$iv = floorPattern;
            boolean $i$f$matchFirst = false;
            objectArray = this_$iv;
            Pattern $this$firstMatcher$iv$iv = pattern$iv;
            boolean $i$f$firstMatcher = false;
            void var9_10 = this_$iv$iv;
            Pattern pattern = $this$firstMatcher$iv$iv;
            Sequence sequence$iv$iv$iv = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
            boolean $i$f$firstMatcher2 = false;
            Iterator iterator3 = sequence$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void $this$firstMatcher$iv$iv$iv;
                String line$iv$iv$iv = (String)iterator3.next();
                Matcher it$iv$iv$iv = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv);
                boolean bl = false;
                if (!it$iv$iv$iv.matches()) continue;
                Intrinsics.checkNotNull(it$iv$iv$iv);
                Matcher $this$onTick_u24lambda_u242 = it$iv$iv$iv;
                boolean bl2 = false;
                String floor = $this$onTick_u24lambda_u242.group("floor");
                dungeonFloor = floor;
                Intrinsics.checkNotNull(floor);
                new DungeonEnterEvent(floor).postAndCatch();
                break;
            }
        }
        if (dungeonFloor != null && playerClass == null) {
            Object v0;
            Object $this$firstOrNull$iv;
            block5: {
                $this$firstOrNull$iv = TabListData.INSTANCE.getTabList();
                boolean $i$f$firstOrNull = false;
                objectArray = $this$firstOrNull$iv.iterator();
                while (objectArray.hasNext()) {
                    Object element$iv = objectArray.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it, LorenzUtils.INSTANCE.getPlayerName(), false, 2, null)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            iterator2 = v0;
            String playerTeam = iterator2 != null && ($this$firstOrNull$iv = StringUtils.removeColor$default(StringUtils.INSTANCE, (CharSequence)((Object)iterator2), false, 1, null)) != null ? $this$firstOrNull$iv : "";
            for (DungeonClass dungeonClass : DungeonClass.getEntries()) {
                if (!StringsKt.contains$default((CharSequence)playerTeam, '(' + dungeonClass.getScoreboardName() + ' ', false, 2, null)) continue;
                objectArray = new String[]{" "};
                String string2 = (String)CollectionsKt.last(StringsKt.split$default((CharSequence)playerTeam, objectArray, false, 0, 6, null));
                objectArray = new char[1];
                objectArray[0] = (String)41;
                int level = NumberUtil.INSTANCE.romanToDecimalIfNecessary(StringsKt.trimEnd(string2, (char[])objectArray));
                playerClass = dungeonClass;
                playerClassLevel = level;
            }
        }
    }

    @SubscribeEvent
    public final void onTabUpdate(@NotNull TablistFooterUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.inDungeon()) {
            return;
        }
        String[] stringArray = new String[]{"\n"};
        for (String line : StringsKt.split$default((CharSequence)event.getFooter(), stringArray, false, 0, 6, null)) {
            String type2;
            if (RegexUtils.INSTANCE.matches(this.getNoBlessingPattern(), line)) {
                DungeonBlessings.Companion.reset();
                return;
            }
            Matcher matcher = this.getBlessingPattern().matcher(line);
            if (!matcher.find() || matcher.group("type") == null) continue;
            String string2 = matcher.group("amount");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            int amount = NumberUtil.INSTANCE.romanToDecimalIfNecessary(string2);
            String string3 = type2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            if (DungeonBlessings.valueOf(string3).getPower() == amount) continue;
            String string4 = type2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
            DungeonBlessings.valueOf(string4).setPower(amount);
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        dungeonFloor = null;
        started = false;
        inBossRoom = false;
        isUniqueClass = false;
        playerClass = null;
        playerClassLevel = -1;
        completed = false;
        DungeonBlessings.Companion.reset();
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Pattern $this$matchMatcher$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String string2 = dungeonFloor;
        if (string2 == null) {
            return;
        }
        String floor = string2;
        if (Intrinsics.areEqual(event.getMessage(), "\u00a7e[NPC] \u00a7bMort\u00a7f: \u00a7rHere, I found this map when I first entered the dungeon.")) {
            started = true;
            new DungeonStartEvent(floor).postAndCatch();
        }
        if (uniqueClassBonus.matches((CharSequence)(object = (CharSequence)StringUtils.removeColor$default(StringUtils.INSTANCE, event.getMessage(), false, 1, null)))) {
            isUniqueClass = true;
        }
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        object = RegexUtils.INSTANCE;
        Pattern pattern = killPattern;
        String text$iv = StringUtils.removeColor$default(StringUtils.INSTANCE, event.getMessage(), false, 1, null);
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u244 = it$iv;
            boolean bl2 = false;
            Map<DungeonFloor, Integer> map2 = INSTANCE.getBossStorage();
            if (map2 == null) {
                return;
            }
            Map<DungeonFloor, Integer> bossCollections = map2;
            String string3 = $this$onChat_u24lambda_u244.group("boss");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            DungeonFloor boss = DungeonFloor.Companion.byBossName(string3);
            if ($this$onChat_u24lambda_u244.matches() && boss != null && !bossCollections.containsKey((Object)boss)) {
                CollectionUtils.INSTANCE.addOrPut(bossCollections, boss, 1);
            }
            return;
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getDungeonComplete();
        text$iv = event.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u245 = it$iv;
            boolean bl3 = false;
            completed = true;
            new DungeonCompleteEvent(floor).postAndCatch();
            return;
        }
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Map<DungeonFloor, Integer> map2 = this.getBossStorage();
        if (map2 == null) {
            return;
        }
        Map<DungeonFloor, Integer> bossCollections = map2;
        if (Intrinsics.areEqual(event.getInventoryName(), "Boss Collections")) {
            this.readAllCollections(bossCollections, event.getInventoryItems());
        } else if (StringsKt.endsWith$default(event.getInventoryName(), " Collection", false, 2, null)) {
            this.readOneMaxCollection(bossCollections, event.getInventoryItems(), event.getInventoryName());
        }
    }

    private final void readOneMaxCollection(Map<DungeonFloor, Integer> bossCollections, Map<Integer, ItemStack> inventoryItems, String inventoryName) {
        block11: {
            ItemStack itemStack2 = inventoryItems.get(48);
            if (itemStack2 == null) break block11;
            ItemStack item = itemStack2;
            boolean bl = false;
            if (Intrinsics.areEqual(ItemUtils.INSTANCE.getName(item), "\u00a7aGo Back")) {
                String string2 = CollectionsKt.getOrNull(ItemUtils.INSTANCE.getLore(item), 0);
                if (string2 != null) {
                    String firstLine = string2;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual(firstLine, "\u00a77To Boss Collections")) {
                        Integer n;
                        Object v4;
                        Object object;
                        DungeonFloor floor;
                        block10: {
                            String[] stringArray = new String[]{" "};
                            String name2 = CollectionsKt.joinToString$default(CollectionsKt.dropLast(StringsKt.split$default((CharSequence)inventoryName, stringArray, false, 0, 6, null), 1), " ", null, null, 0, null, null, 62, null);
                            DungeonFloor dungeonFloor = DungeonFloor.Companion.byBossName(name2);
                            if (dungeonFloor == null) {
                                return;
                            }
                            floor = dungeonFloor;
                            Object object2 = inventoryItems.get(4);
                            if (object2 == null || (object2 = ItemUtils.INSTANCE.getLore((ItemStack)object2)) == null) {
                                return;
                            }
                            Object lore = object2;
                            object = (Iterable)lore;
                            Iterator iterator2 = object.iterator();
                            while (iterator2.hasNext()) {
                                Object t = iterator2.next();
                                String it = (String)t;
                                boolean bl3 = false;
                                if (!StringsKt.contains$default((CharSequence)it, "Total Kills:", false, 2, null)) continue;
                                v4 = t;
                                break block10;
                            }
                            v4 = null;
                        }
                        String string3 = v4;
                        if (string3 == null) {
                            return;
                        }
                        String line = string3;
                        object = RegexUtils.INSTANCE;
                        Pattern $this$matchMatcher$iv = totalKillsPattern;
                        boolean $i$f$matchMatcher = false;
                        Matcher it$iv = $this$matchMatcher$iv.matcher(line);
                        boolean bl4 = false;
                        if (it$iv.matches()) {
                            Intrinsics.checkNotNull(it$iv);
                            Matcher $this$readOneMaxCollection_u24lambda_u249_u24lambda_u248_u24lambda_u247 = it$iv;
                            boolean bl5 = false;
                            String string4 = $this$readOneMaxCollection_u24lambda_u249_u24lambda_u248_u24lambda_u247.group("kills");
                            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
                            n = NumberUtil.INSTANCE.formatInt(string4);
                        } else {
                            n = null;
                        }
                        if (n == null) {
                            return;
                        }
                        int kills = n;
                        object = kills;
                        bossCollections.put(floor, (Integer)object);
                    }
                }
            }
        }
    }

    private final void readAllCollections(Map<DungeonFloor, Integer> bossCollections, Map<Integer, ItemStack> inventoryItems) {
        for (ItemStack stack : inventoryItems.values()) {
            DungeonFloor floor;
            String name2 = null;
            name2 = "";
            int kills = 0;
            for (String line : ItemUtils.INSTANCE.getLore(stack)) {
                String colorlessLine = StringUtils.removeColor$default(StringUtils.INSTANCE, line, false, 1, null);
                RegexUtils regexUtils = RegexUtils.INSTANCE;
                Pattern $this$matchMatcher$iv = bossPattern;
                boolean $i$f$matchMatcher = false;
                Matcher it$iv = $this$matchMatcher$iv.matcher(colorlessLine);
                boolean bl = false;
                if (it$iv.matches()) {
                    Intrinsics.checkNotNull(it$iv);
                    Matcher $this$readAllCollections_u24lambda_u2410 = it$iv;
                    boolean bl2 = false;
                    if ($this$readAllCollections_u24lambda_u2410.matches()) {
                        name2 = $this$readAllCollections_u24lambda_u2410.group("name");
                    }
                }
                RegexUtils this_$iv = RegexUtils.INSTANCE;
                $this$matchMatcher$iv = levelPattern;
                $i$f$matchMatcher = false;
                it$iv = $this$matchMatcher$iv.matcher(colorlessLine);
                bl = false;
                if (!it$iv.matches()) continue;
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$readAllCollections_u24lambda_u2411 = it$iv;
                boolean bl3 = false;
                if (!$this$readAllCollections_u24lambda_u2411.matches()) continue;
                String string2 = $this$readAllCollections_u24lambda_u2411.group("kills");
                Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                kills = Integer.parseInt(string2);
                break;
            }
            if (DungeonFloor.Companion.byBossName(name2) == null) continue;
            bossCollections.put(floor, kills);
        }
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Dungeon");
        if (!this.inDungeon()) {
            event.addIrrelevant("not in dungeons");
            return;
        }
        event.addData(DungeonAPI::onDebugDataCollect$lambda$13);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public final void onBlockClick(@NotNull BlockClickEvent event) {
        ClickedBlockType clickedBlockType;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.inDungeon() || event.getClickType() != ClickType.RIGHT_CLICK) {
            return;
        }
        LorenzVec position = event.getPosition();
        Block block = BlockUtils.INSTANCE.getBlockAt(position);
        if (Intrinsics.areEqual(block, Blocks.field_150486_ae)) {
            clickedBlockType = ClickedBlockType.CHEST;
        } else if (Intrinsics.areEqual(block, Blocks.field_150447_bR)) {
            clickedBlockType = ClickedBlockType.TRAPPED_CHEST;
        } else if (Intrinsics.areEqual(block, Blocks.field_150442_at)) {
            clickedBlockType = ClickedBlockType.LEVER;
        } else {
            if (!Intrinsics.areEqual(block, Blocks.field_150465_bP)) return;
            String blockTexture = BlockUtils.INSTANCE.getTextureFromSkull(position.toBlockPos());
            if (!Intrinsics.areEqual(blockTexture, WITHER_ESSENCE_TEXTURE)) return;
            clickedBlockType = ClickedBlockType.WITHER_ESSENCE;
        }
        ClickedBlockType blockType = clickedBlockType;
        new DungeonBlockClickEvent(position, blockType).post();
    }

    private static final Unit onDebugDataCollect$lambda$13(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("dungeonFloor: " + dungeonFloor);
        $this$addData.add("started: " + started);
        $this$addData.add("getRoomID: " + INSTANCE.getRoomID());
        $this$addData.add("inBossRoom: " + inBossRoom);
        $this$addData.add("");
        $this$addData.add("playerClass: " + (Object)((Object)playerClass));
        $this$addData.add("isUniqueClass: " + isUniqueClass);
        $this$addData.add("playerClassLevel: " + playerClassLevel);
        $this$addData.add("");
        $this$addData.add("Blessings: ");
        Iterable $this$forEach$iv = DungeonBlessings.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DungeonBlessings it = (DungeonBlessings)((Object)element$iv);
            boolean bl = false;
            $this$addData.add("  " + it.getDisplayName() + ' ' + it.getPower());
        }
        return Unit.INSTANCE;
    }

    static {
        Object object = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DungeonAPI.class, "timePattern", "getTimePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(DungeonAPI.class, "dungeonComplete", "getDungeonComplete()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(DungeonAPI.class, "dungeonRoomPattern", "getDungeonRoomPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(DungeonAPI.class, "blessingPattern", "getBlessingPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(DungeonAPI.class, "noBlessingPattern", "getNoBlessingPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = object;
        INSTANCE = new DungeonAPI();
        object = " \u00a77\u23e3 \u00a7cThe Catacombs \u00a77\\((?<floor>.*)\\)";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        floorPattern = pattern;
        uniqueClassBonus = new Regex("^Your ([A-Za-z]+) stats are doubled because you are the only player using this class!$");
        object = "View all your (?<name>\\w+) Collection";
        n = 0;
        Pattern pattern2 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern2, "compile(...)");
        bossPattern = pattern2;
        object = " +(?<kills>\\d+).*";
        n = 0;
        Pattern pattern3 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern3, "compile(...)");
        levelPattern = pattern3;
        object = " +\u2620 Defeated (?<boss>\\w+).*";
        n = 0;
        Pattern pattern4 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern4, "compile(...)");
        killPattern = pattern4;
        object = "\u00a77Total Kills: \u00a7e(?<kills>.*)";
        n = 0;
        Pattern pattern5 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern5, "compile(...)");
        totalKillsPattern = pattern5;
        playerClassLevel = -1;
        patternGroup = RepoPattern.Companion.group("dungeon");
        timePattern$delegate = patternGroup.pattern("time", "Time Elapsed: \u00a7.(?:(?<minutes>\\d+)m )?(?<seconds>\\d+)s");
        dungeonComplete$delegate = patternGroup.pattern("complete", "\u00a7.\\s+\u00a7.\u00a7.(?:Master Mode )?The Catacombs \u00a7.\u00a7.- \u00a7.\u00a7.(?:Floor )?(?<floor>M?[IV]{1,3}|Entrance)");
        dungeonRoomPattern$delegate = patternGroup.pattern("room", "\u00a77\\d+\\/\\d+\\/\\d+ \u00a7\\w+ (?<roomId>[\\w,-]+)");
        blessingPattern$delegate = patternGroup.pattern("blessings", "\u00a7r\u00a7r\u00a7fBlessing of (?<type>\\w+) (?<amount>\\w+)\u00a7r");
        noBlessingPattern$delegate = patternGroup.pattern("noblessings", "\u00a7r\u00a7r\u00a77No Buffs active. Find them by exploring the Dungeon!\u00a7r");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001b\u0010\u0010\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonBlessings;", "", "", "power", "<init>", "(Ljava/lang/String;II)V", "I", "getPower", "()I", "setPower", "(I)V", "", "displayName$delegate", "Lkotlin/Lazy;", "getDisplayName", "()Ljava/lang/String;", "displayName", "Companion", "LIFE", "POWER", "STONE", "WISDOM", "TIME", "1.8.9"})
    public static final class DungeonBlessings
    extends Enum<DungeonBlessings> {
        @NotNull
        public static final Companion Companion;
        private int power;
        @NotNull
        private final Lazy displayName$delegate;
        public static final /* enum */ DungeonBlessings LIFE;
        public static final /* enum */ DungeonBlessings POWER;
        public static final /* enum */ DungeonBlessings STONE;
        public static final /* enum */ DungeonBlessings WISDOM;
        public static final /* enum */ DungeonBlessings TIME;
        private static final /* synthetic */ DungeonBlessings[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DungeonBlessings(int power) {
            this.power = power;
            this.displayName$delegate = LazyKt.lazy(() -> DungeonBlessings.displayName_delegate$lambda$0(this));
        }

        public final int getPower() {
            return this.power;
        }

        public final void setPower(int n) {
            this.power = n;
        }

        @NotNull
        public final String getDisplayName() {
            Lazy lazy = this.displayName$delegate;
            return (String)lazy.getValue();
        }

        public static DungeonBlessings[] values() {
            return (DungeonBlessings[])$VALUES.clone();
        }

        public static DungeonBlessings valueOf(String value) {
            return Enum.valueOf(DungeonBlessings.class, value);
        }

        @NotNull
        public static EnumEntries<DungeonBlessings> getEntries() {
            return $ENTRIES;
        }

        private static final String displayName_delegate$lambda$0(DungeonBlessings this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
            return StringUtils.INSTANCE.firstLetterUppercase(this$0.name());
        }

        static {
            LIFE = new DungeonBlessings(0);
            POWER = new DungeonBlessings(0);
            STONE = new DungeonBlessings(0);
            WISDOM = new DungeonBlessings(0);
            TIME = new DungeonBlessings(0);
            $VALUES = dungeonBlessingsArray = new DungeonBlessings[]{DungeonBlessings.LIFE, DungeonBlessings.POWER, DungeonBlessings.STONE, DungeonBlessings.WISDOM, DungeonBlessings.TIME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonBlessings$Companion;", "", "<init>", "()V", "", "reset", "1.8.9"})
        @SourceDebugExtension(value={"SMAP\nDungeonAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonAPI.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonBlessings$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n1863#2,2:387\n*S KotlinDebug\n*F\n+ 1 DungeonAPI.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonBlessings$Companion\n*L\n109#1:387,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            public final void reset() {
                Iterable $this$forEach$iv = DungeonBlessings.getEntries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DungeonBlessings it = (DungeonBlessings)((Object)element$iv);
                    boolean bl = false;
                    it.setPower(0);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonChest;", "", "", "inventory", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getInventory", "()Ljava/lang/String;", "Companion", "WOOD", "GOLD", "DIAMOND", "EMERALD", "OBSIDIAN", "BEDROCK", "1.8.9"})
    public static final class DungeonChest
    extends Enum<DungeonChest> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String inventory;
        public static final /* enum */ DungeonChest WOOD;
        public static final /* enum */ DungeonChest GOLD;
        public static final /* enum */ DungeonChest DIAMOND;
        public static final /* enum */ DungeonChest EMERALD;
        public static final /* enum */ DungeonChest OBSIDIAN;
        public static final /* enum */ DungeonChest BEDROCK;
        private static final /* synthetic */ DungeonChest[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DungeonChest(String inventory) {
            this.inventory = inventory;
        }

        @NotNull
        public final String getInventory() {
            return this.inventory;
        }

        public static DungeonChest[] values() {
            return (DungeonChest[])$VALUES.clone();
        }

        public static DungeonChest valueOf(String value) {
            return Enum.valueOf(DungeonChest.class, value);
        }

        @NotNull
        public static EnumEntries<DungeonChest> getEntries() {
            return $ENTRIES;
        }

        static {
            WOOD = new DungeonChest("Wood Chest");
            GOLD = new DungeonChest("Gold Chest");
            DIAMOND = new DungeonChest("Diamond Chest");
            EMERALD = new DungeonChest("Emerald Chest");
            OBSIDIAN = new DungeonChest("Obsidian Chest");
            BEDROCK = new DungeonChest("Bedrock Chest");
            $VALUES = dungeonChestArray = new DungeonChest[]{DungeonChest.WOOD, DungeonChest.GOLD, DungeonChest.DIAMOND, DungeonChest.EMERALD, DungeonChest.OBSIDIAN, DungeonChest.BEDROCK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonChest$Companion;", "", "<init>", "()V", "", "inventory", "Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonChest;", "getByInventoryName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonChest;", "1.8.9"})
        @SourceDebugExtension(value={"SMAP\nDungeonAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonAPI.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonChest$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n295#2,2:387\n*S KotlinDebug\n*F\n+ 1 DungeonAPI.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonChest$Companion\n*L\n359#1:387,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DungeonChest getByInventoryName(@NotNull String inventory) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter(inventory, "inventory");
                    Iterable $this$firstOrNull$iv = DungeonChest.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        DungeonChest it = (DungeonChest)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getInventory(), inventory)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonAPI$DungeonClass;", "", "", "scoreboardName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getScoreboardName", "()Ljava/lang/String;", "ARCHER", "BERSERK", "HEALER", "MAGE", "TANK", "1.8.9"})
    public static final class DungeonClass
    extends Enum<DungeonClass> {
        @NotNull
        private final String scoreboardName;
        public static final /* enum */ DungeonClass ARCHER = new DungeonClass("Archer");
        public static final /* enum */ DungeonClass BERSERK = new DungeonClass("Berserk");
        public static final /* enum */ DungeonClass HEALER = new DungeonClass("Healer");
        public static final /* enum */ DungeonClass MAGE = new DungeonClass("Mage");
        public static final /* enum */ DungeonClass TANK = new DungeonClass("Tank");
        private static final /* synthetic */ DungeonClass[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DungeonClass(String scoreboardName) {
            this.scoreboardName = scoreboardName;
        }

        @NotNull
        public final String getScoreboardName() {
            return this.scoreboardName;
        }

        public static DungeonClass[] values() {
            return (DungeonClass[])$VALUES.clone();
        }

        public static DungeonClass valueOf(String value) {
            return Enum.valueOf(DungeonClass.class, value);
        }

        @NotNull
        public static EnumEntries<DungeonClass> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dungeonClassArray = new DungeonClass[]{DungeonClass.ARCHER, DungeonClass.BERSERK, DungeonClass.HEALER, DungeonClass.MAGE, DungeonClass.TANK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

