/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.combat.broodmother.BroodmotherConfig;
import at.hannibal2.skyhanni.config.features.combat.broodmother.BroodmotherSpawnAlertConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.WidgetUpdateEvent;
import at.hannibal2.skyhanni.features.combat.SpidersDenAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.audio.ISound;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u0003J\u000f\u0010\u001a\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\fJ\u000f\u0010\u001b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001b\u0010\fJ\u000f\u0010\u001c\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001c\u0010\fR\u001c\u0010!\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010%\u001a\n \u001e*\u0004\u0018\u00010\"0\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0018\u0010'\u001a\u0004\u0018\u00010&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0018\u0010)\u001a\u0004\u0018\u00010&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010.\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lat/hannibal2/skyhanni/features/combat/BroodmotherFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;", "event", "", "onTabListUpdate", "(Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;)V", "onStageUpdate", "", "onServerJoin", "()Z", "onBroodmotherSpawn", "playImminentWarning", "onBroodmotherSlain", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "playTestSound", "inSpidersDen", "isCountdownEnabled", "isAliveMessageEnabled", "Lat/hannibal2/skyhanni/config/features/combat/broodmother/BroodmotherConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/broodmother/BroodmotherConfig;", "config", "Lat/hannibal2/skyhanni/config/features/combat/broodmother/BroodmotherSpawnAlertConfig;", "getSpawnAlertConfig", "()Lat/hannibal2/skyhanni/config/features/combat/broodmother/BroodmotherSpawnAlertConfig;", "spawnAlertConfig", "Lat/hannibal2/skyhanni/features/combat/BroodmotherFeatures$StageEntry;", "lastStage", "Lat/hannibal2/skyhanni/features/combat/BroodmotherFeatures$StageEntry;", "currentStage", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "broodmotherSpawnTime", "J", "", "display", "Ljava/lang/String;", "StageEntry", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nBroodmotherFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroodmotherFeatures.kt\nat/hannibal2/skyhanni/features/combat/BroodmotherFeatures\n+ 2 TabWidget.kt\nat/hannibal2/skyhanni/data/model/TabWidget\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n339#2,2:183\n341#2:187\n8#3:185\n1#4:186\n*S KotlinDebug\n*F\n+ 1 BroodmotherFeatures.kt\nat/hannibal2/skyhanni/features/combat/BroodmotherFeatures\n*L\n52#1:183,2\n52#1:187\n52#1:185\n52#1:186\n*E\n"})
public final class BroodmotherFeatures {
    @NotNull
    public static final BroodmotherFeatures INSTANCE = new BroodmotherFeatures();
    @Nullable
    private static StageEntry lastStage;
    @Nullable
    private static StageEntry currentStage;
    private static long broodmotherSpawnTime;
    @NotNull
    private static String display;

    private BroodmotherFeatures() {
    }

    private final BroodmotherConfig getConfig() {
        return SkyHanniMod.feature.combat.broodmother;
    }

    private final BroodmotherSpawnAlertConfig getSpawnAlertConfig() {
        return this.getConfig().spawnAlert;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTabListUpdate(@NotNull WidgetUpdateEvent event) {
        String newStage;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!event.isWidget(TabWidget.BROODMOTHER)) {
            return;
        }
        TabWidget this_$iv = event.getWidget();
        boolean $i$f$matchMatcherFirstLine = false;
        if (this_$iv.isActive()) {
            void $this$matchMatcher$iv$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this_$iv.getPattern();
            String text$iv$iv = CollectionsKt.first(this_$iv.getLines());
            boolean $i$f$matchMatcher = false;
            Matcher it$iv$iv = $this$matchMatcher$iv$iv.matcher(text$iv$iv);
            boolean bl = false;
            if (it$iv$iv.matches()) {
                Intrinsics.checkNotNull(it$iv$iv);
                Matcher $this$onTabListUpdate_u24lambda_u240 = it$iv$iv;
                boolean bl2 = false;
                string3 = $this$onTabListUpdate_u24lambda_u240.group("stage");
            } else {
                string3 = null;
            }
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = "";
        }
        if (((CharSequence)(newStage = string2)).length() > 0) {
            lastStage = currentStage;
            String string4 = StringsKt.replace$default(newStage, "!", "", false, 4, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
            currentStage = StageEntry.valueOf(string4);
            this.onStageUpdate();
        }
    }

    private final void onStageUpdate() {
        ChatUtils.INSTANCE.debug("New Broodmother stage: " + (Object)((Object)currentStage));
        if (lastStage == null && this.onServerJoin()) {
            return;
        }
        if (currentStage == StageEntry.IMMINENT && lastStage == StageEntry.ALIVE) {
            return;
        }
        if (currentStage == StageEntry.ALIVE) {
            this.onBroodmotherSpawn();
            return;
        }
        if (currentStage == StageEntry.IMMINENT && this.getConfig().imminentWarning) {
            this.playImminentWarning();
            return;
        }
        StageEntry stageEntry = lastStage;
        if (stageEntry == null) {
            return;
        }
        StageEntry lastStage = stageEntry;
        StageEntry stageEntry2 = currentStage;
        if (stageEntry2 == null) {
            return;
        }
        int n = stageEntry2.getMinutes();
        long timeUntilSpawn = DurationKt.toDuration(n, DurationUnit.MINUTES);
        broodmotherSpawnTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), timeUntilSpawn);
        if (!this.getConfig().stages.contains((Object)currentStage)) {
            return;
        }
        if (currentStage == StageEntry.SLAIN) {
            this.onBroodmotherSlain();
        } else {
            String pluralize = StringUtils.pluralize$default(StringUtils.INSTANCE, Duration.toInt-impl(timeUntilSpawn, DurationUnit.MINUTES), "minute", null, false, 12, null);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Broodmother: " + (Object)((Object)lastStage) + " \u00a7e-> " + (Object)((Object)currentStage) + "\u00a7e. \u00a7b" + Duration.getInWholeMinutes-impl(timeUntilSpawn) + ' ' + pluralize + " \u00a7euntil it spawns!", false, null, 6, null);
        }
    }

    private final boolean onServerJoin() {
        if (this.getConfig().stageOnJoin && (currentStage != StageEntry.ALIVE || !this.isAliveMessageEnabled())) {
            StageEntry stageEntry = currentStage;
            String pluralize = StringUtils.pluralize$default(StringUtils.INSTANCE, stageEntry != null ? stageEntry.getMinutes() : 0, "minute", null, false, 12, null);
            String message = "The Broodmother's current stage in this server is " + StringsKt.replace$default(String.valueOf((Object)currentStage), "!", "", false, 4, null) + "\u00a7e.";
            StageEntry stageEntry2 = currentStage;
            if (!(stageEntry2 != null ? stageEntry2.getMinutes() == 0 : false)) {
                StageEntry stageEntry3 = currentStage;
                message = message + " It will spawn \u00a7bwithin " + (stageEntry3 != null ? Integer.valueOf(stageEntry3.getMinutes()) : null) + ' ' + pluralize + "\u00a7e.";
            }
            ChatUtils.chat$default(ChatUtils.INSTANCE, message, false, null, 6, null);
            return true;
        }
        return false;
    }

    private final void onBroodmotherSpawn() {
        broodmotherSpawnTime = SimpleTimeMark.Companion.farPast();
        if (!this.isAliveMessageEnabled()) {
            return;
        }
        KMutableProperty0 feature = null;
        if (this.getConfig().alertOnSpawn) {
            feature = new MutablePropertyReference0Impl(this.getConfig()){

                public Object get() {
                    return ((BroodmotherConfig)this.receiver).alertOnSpawn;
                }

                public void set(Object value) {
                    ((BroodmotherConfig)this.receiver).alertOnSpawn = (Boolean)value;
                }
            };
            String string2 = this.getSpawnAlertConfig().alertSound;
            Intrinsics.checkNotNullExpressionValue(string2, "alertSound");
            ISound alertSound = SoundUtils.createSound$default(SoundUtils.INSTANCE, string2, this.getSpawnAlertConfig().pitch, 0.0f, 4, null);
            SoundUtils.INSTANCE.repeatSound(100L, this.getSpawnAlertConfig().repeatSound, alertSound);
            String string3 = this.getSpawnAlertConfig().text;
            Intrinsics.checkNotNullExpressionValue(string3, "text");
            LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, StringsKt.replace$default(string3, "&", "\u00a7", false, 4, null), DurationKt.toDuration(3, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        } else {
            feature = new MutablePropertyReference0Impl(this.getConfig()){

                public Object get() {
                    return ((BroodmotherConfig)this.receiver).stages;
                }

                public void set(Object value) {
                    ((BroodmotherConfig)this.receiver).stages = (List)value;
                }
            };
        }
        ChatUtils.INSTANCE.clickToActionOrDisable("The Broodmother has spawned!", feature, "warp to the Top of the Nest", BroodmotherFeatures::onBroodmotherSpawn$lambda$1);
    }

    private final void playImminentWarning() {
        SoundUtils.INSTANCE.repeatSound(100L, 2, SoundUtils.createSound$default(SoundUtils.INSTANCE, "note.pling", 0.5f, 0.0f, 4, null));
        ChatUtils.chat$default(ChatUtils.INSTANCE, "The Broodmother is \u00a74Imminent\u00a7e! It will spawn in \u00a7b60 seconds\u00a7e!", false, null, 6, null);
    }

    private final void onBroodmotherSlain() {
        broodmotherSpawnTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(10, DurationUnit.MINUTES));
        if (!this.getConfig().hideSlainWhenNearby || !SpidersDenAPI.INSTANCE.isAtTopOfNest()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "The Broodmother was killed!", false, null, 6, null);
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        broodmotherSpawnTime = SimpleTimeMark.Companion.farPast();
        lastStage = null;
        currentStage = null;
        display = "";
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isCountdownEnabled()) {
            return;
        }
        if (((CharSequence)display).length() == 0) {
            return;
        }
        Position position = this.getConfig().countdownPosition;
        Intrinsics.checkNotNullExpressionValue(position, "countdownPosition");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, display, 0, 0, "Broodmother Countdown", 6, null);
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isCountdownEnabled()) {
            return;
        }
        if (SimpleTimeMark.isFarPast-impl(broodmotherSpawnTime)) {
            if (lastStage != null && currentStage == StageEntry.ALIVE) {
                display = "\u00a74Broodmother spawned!";
            }
        } else {
            String countdown = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, SimpleTimeMark.timeUntil-UwyO8pc(broodmotherSpawnTime), null, false, false, 0, false, 31, null);
            display = "\u00a74Broodmother spawning in \u00a7b" + countdown;
        }
    }

    @JvmStatic
    public static final void playTestSound() {
        BroodmotherSpawnAlertConfig $this$playTestSound_u24lambda_u242 = INSTANCE.getSpawnAlertConfig();
        boolean bl = false;
        String string2 = $this$playTestSound_u24lambda_u242.alertSound;
        Intrinsics.checkNotNullExpressionValue(string2, "alertSound");
        SoundUtils.INSTANCE.playSound(SoundUtils.createSound$default(SoundUtils.INSTANCE, string2, $this$playTestSound_u24lambda_u242.pitch, 0.0f, 4, null));
    }

    private final boolean inSpidersDen() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.SPIDER_DEN);
    }

    private final boolean isCountdownEnabled() {
        return this.inSpidersDen() && this.getConfig().countdown;
    }

    private final boolean isAliveMessageEnabled() {
        return this.getConfig().alertOnSpawn || this.getConfig().stages.contains((Object)StageEntry.ALIVE);
    }

    private static final Unit onBroodmotherSpawn$lambda$1() {
        HypixelCommands.INSTANCE.warp("nest");
        return Unit.INSTANCE;
    }

    static {
        broodmotherSpawnTime = SimpleTimeMark.Companion.farPast();
        display = "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/features/combat/BroodmotherFeatures$StageEntry;", "", "", "str", "", "minutes", "<init>", "(Ljava/lang/String;ILjava/lang/String;I)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "I", "getMinutes", "()I", "SLAIN", "DORMANT", "SOON", "AWAKENING", "IMMINENT", "ALIVE", "1.8.9"})
    public static final class StageEntry
    extends Enum<StageEntry> {
        @NotNull
        private final String str;
        private final int minutes;
        public static final /* enum */ StageEntry SLAIN = new StageEntry("\u00a7eSlain", 10);
        public static final /* enum */ StageEntry DORMANT = new StageEntry("\u00a7eDormant", 9);
        public static final /* enum */ StageEntry SOON = new StageEntry("\u00a76Soon", 6);
        public static final /* enum */ StageEntry AWAKENING = new StageEntry("\u00a76Awakening", 3);
        public static final /* enum */ StageEntry IMMINENT = new StageEntry("\u00a74Imminent", 1);
        public static final /* enum */ StageEntry ALIVE = new StageEntry("\u00a74Alive!", 0);
        private static final /* synthetic */ StageEntry[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private StageEntry(String str, int minutes) {
            this.str = str;
            this.minutes = minutes;
        }

        public final int getMinutes() {
            return this.minutes;
        }

        @NotNull
        public String toString() {
            return this.str;
        }

        public static StageEntry[] values() {
            return (StageEntry[])$VALUES.clone();
        }

        public static StageEntry valueOf(String value) {
            return Enum.valueOf(StageEntry.class, value);
        }

        @NotNull
        public static EnumEntries<StageEntry> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stageEntryArray = new StageEntry[]{StageEntry.SLAIN, StageEntry.DORMANT, StageEntry.SOON, StageEntry.AWAKENING, StageEntry.IMMINENT, StageEntry.ALIVE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

