/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.chat.translation;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.chat.TranslatorConfig;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.features.chat.translation.TranslatableLanguage;
import at.hannibal2.skyhanni.utils.APIUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010 \u001a\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e\u00a2\u0006\u0004\b \u0010!J\u001b\u0010\"\u001a\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e\u00a2\u0006\u0004\b\"\u0010!J\r\u0010$\u001a\u00020#\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\"\u0010*\u001a\u00020)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00104\u001a\n 1*\u0004\u0018\u000100008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00065"}, d2={"Lat/hannibal2/skyhanni/features/chat/translation/Translator;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigReload", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "", "message", "Lnet/minecraft/util/ChatStyle;", "style", "createClickStyle", "(Ljava/lang/String;Lnet/minecraft/util/ChatStyle;)Lnet/minecraft/util/ChatStyle;", "urlString", "Lcom/google/gson/JsonElement;", "getJSONResponse", "(Ljava/lang/String;)Lcom/google/gson/JsonElement;", "getTranslationToEnglish", "(Ljava/lang/String;)Ljava/lang/String;", "lang", "getTranslationFromEnglish", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "args", "toEnglish", "([Ljava/lang/String;)V", "fromEnglish", "", "isEnabled", "()Z", "Lkotlin/text/Regex;", "messageContentRegex", "Lkotlin/text/Regex;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastUserChange", "J", "getLastUserChange-uFjCsEo", "()J", "setLastUserChange-gJLAdNM", "(J)V", "Lat/hannibal2/skyhanni/config/features/chat/TranslatorConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/chat/TranslatorConfig;", "config", "1.8.9"})
public final class Translator {
    @NotNull
    public static final Translator INSTANCE = new Translator();
    @NotNull
    private static final Regex messageContentRegex = new Regex(".*: (.*)");
    private static long lastUserChange = SimpleTimeMark.Companion.farPast();

    private Translator() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        String message = event.getMessage();
        if (StringUtils.INSTANCE.getPlayerNameFromChatMessage(message) == null) {
            return;
        }
        IChatComponent editedComponent = ConditionalUtils.INSTANCE.transformIf(event.getChatComponent(), Translator::onChat$lambda$0, Translator::onChat$lambda$1);
        ChatStyle chatStyle = editedComponent.func_150256_b();
        if ((chatStyle != null && (chatStyle = chatStyle.func_150235_h()) != null ? chatStyle.func_150669_a() : null) == ClickEvent.Action.OPEN_URL) {
            return;
        }
        ChatStyle chatStyle2 = editedComponent.func_150256_b();
        Intrinsics.checkNotNullExpressionValue(chatStyle2, "getChatStyle(...)");
        ChatStyle clickStyle = this.createClickStyle(message, chatStyle2);
        editedComponent.func_150255_a(clickStyle);
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 55, "chat.translator", "chat.translator.translateOnClick", null, 8, null);
    }

    public final long getLastUserChange-uFjCsEo() {
        return lastUserChange;
    }

    public final void setLastUserChange-gJLAdNM(long l) {
        lastUserChange = l;
    }

    @SubscribeEvent
    public final void onConfigReload(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property<String> property = this.getConfig().languageCode;
        Intrinsics.checkNotNullExpressionValue(property, "languageCode");
        ConditionalUtils.INSTANCE.onToggle(property, Translator::onConfigReload$lambda$2);
        Property<TranslatableLanguage> property2 = this.getConfig().languageName;
        Intrinsics.checkNotNullExpressionValue(property2, "languageName");
        ConditionalUtils.INSTANCE.onToggle(property2, Translator::onConfigReload$lambda$3);
    }

    private final ChatStyle createClickStyle(String message, ChatStyle style) {
        MatchResult matchResult = Regex.find$default(messageContentRegex, message, 0, 2, null);
        Intrinsics.checkNotNull(matchResult);
        String text = StringUtils.removeColor$default(StringUtils.INSTANCE, matchResult.getGroupValues().get(1), false, 1, null);
        style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/shtranslate " + text));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("\u00a7bClick to translate!")));
        return style;
    }

    private final TranslatorConfig getConfig() {
        return SkyHanniMod.feature.chat.translator;
    }

    private final JsonElement getJSONResponse(String urlString) {
        return APIUtils.INSTANCE.getJSONResponseAsElement(urlString, false, "Google Translate API");
    }

    private final String getTranslationToEnglish(String message) {
        Object object;
        String url = "https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl=en&dt=t&q=" + URLEncoder.encode(message, "UTF-8");
        String messageToSend = "";
        JsonArray layer1 = this.getJSONResponse(url).getAsJsonArray();
        if (layer1.size() <= 2) {
            return "Error!";
        }
        String string2 = layer1.get(2).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String language = string2;
        if (Intrinsics.areEqual(language, "\"en\"")) {
            return "Unable to translate!";
        }
        if (language.length() != 4) {
            return "Error!";
        }
        try {
            JsonElement jsonElement = layer1.get(0);
            Intrinsics.checkNotNull(jsonElement, "null cannot be cast to non-null type com.google.gson.JsonArray");
            object = (JsonArray)jsonElement;
        }
        catch (Exception exception) {
            return "Error!";
        }
        JsonArray layer2 = object;
        Iterator iterator2 = layer2.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        object = iterator2;
        while (object.hasNext()) {
            String sentenceWithoutQuotes;
            String sentence;
            JsonArray arrayLayer3;
            JsonElement layer3 = (JsonElement)object.next();
            if ((layer3 instanceof JsonArray ? (JsonArray)layer3 : null) == null) continue;
            arrayLayer3 = arrayLayer3;
            Intrinsics.checkNotNullExpressionValue(arrayLayer3.get(0).toString(), "toString(...)");
            Intrinsics.checkNotNullExpressionValue(sentence.substring(1, sentence.length() - 1), "substring(...)");
            messageToSend = messageToSend + sentenceWithoutQuotes;
        }
        messageToSend = messageToSend + " \u00a77(Language: " + language + ')';
        String string3 = URLDecoder.decode(messageToSend, "UTF-8");
        Intrinsics.checkNotNullExpressionValue(string3, "decode(...)");
        return StringsKt.replace$default(string3, "\\", "", false, 4, null);
    }

    private final String getTranslationFromEnglish(String message, String lang) {
        JsonArray layer2;
        String url = "https://translate.googleapis.com/translate_a/single?client=gtx&sl=en&tl=" + lang + "&dt=t&q=" + URLEncoder.encode(message, "UTF-8");
        JsonArray layer1 = this.getJSONResponse(url).getAsJsonArray();
        if (layer1.size() < 1) {
            return "Error!";
        }
        JsonElement jsonElement = layer1.get(0);
        JsonArray jsonArray = layer2 = jsonElement instanceof JsonArray ? (JsonArray)jsonElement : null;
        JsonElement jsonElement2 = jsonArray != null ? jsonArray.get(0) : null;
        JsonArray jsonArray2 = jsonElement2 instanceof JsonArray ? (JsonArray)jsonElement2 : null;
        String firstSentence = String.valueOf(jsonArray2 != null ? jsonArray2.get(0) : null);
        String string2 = firstSentence.substring(0, firstSentence.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String messageToSend = string2;
        if (layer2 != null) {
            int n = layer2.size();
            for (int sentenceIndex = 1; sentenceIndex < n; ++sentenceIndex) {
                String sentenceWithoutQuotes;
                String sentence;
                JsonElement jsonElement3 = layer2.get(sentenceIndex);
                Intrinsics.checkNotNull(jsonElement3, "null cannot be cast to non-null type com.google.gson.JsonArray");
                Intrinsics.checkNotNullExpressionValue(((JsonArray)jsonElement3).get(0).toString(), "toString(...)");
                Intrinsics.checkNotNullExpressionValue(sentence.substring(1, sentence.length() - 1), "substring(...)");
                messageToSend = messageToSend + sentenceWithoutQuotes;
            }
        }
        String string3 = messageToSend.substring(1, messageToSend.length());
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        messageToSend = string3;
        String string4 = URLDecoder.decode(messageToSend, "UTF-8");
        Intrinsics.checkNotNullExpressionValue(string4, "decode(...)");
        return StringsKt.replace$default(string4, "\\", "", false, 4, null);
    }

    public final void toEnglish(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        String message = StringUtils.removeColor$default(StringUtils.INSTANCE, ArraysKt.joinToString$default(args2, (CharSequence)" ", null, null, 0, null, null, 62, null), false, 1, null);
        BuildersKt.launch$default(SkyHanniMod.Companion.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(message, null){
            int label;
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String translation;
                        String string2;
                        String lang;
                        ResultKt.throwOnFailure(object);
                        String string3 = lang = (String)Translator.access$getConfig((Translator)Translator.INSTANCE).languageCode.get();
                        Intrinsics.checkNotNull(string3);
                        if (((CharSequence)string3).length() == 0) {
                            string2 = Translator.access$getTranslationToEnglish(Translator.INSTANCE, this.$message);
                        } else {
                            string3 = lang;
                            Intrinsics.checkNotNull(string3);
                            string2 = translation = Translator.access$getTranslationFromEnglish(Translator.INSTANCE, this.$message, string3);
                        }
                        if (Intrinsics.areEqual(this.$message, translation)) {
                            ChatUtils.INSTANCE.userError("Translation is the same as the original message!");
                            return Unit.INSTANCE;
                        }
                        if (Intrinsics.areEqual(translation, "Unable to translate!")) {
                            ChatUtils.INSTANCE.userError("Unable to translate message :( (is it in English?)");
                            return Unit.INSTANCE;
                        }
                        ChatUtils.chat$default(ChatUtils.INSTANCE, "Found translation: \u00a7f" + translation, false, null, 6, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public final void fromEnglish(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (args2.length < 2 || args2[0].length() != 2) {
            ChatUtils.INSTANCE.userError("Usage: /shcopytranslation <two letter language code (at the end of a translation)> <message>");
            return;
        }
        String language = args2[0];
        String message = CollectionsKt.joinToString$default(ArraysKt.drop(args2, 1), " ", null, null, 0, null, null, 62, null);
        BuildersKt.launch$default(SkyHanniMod.Companion.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(message, language, null){
            int label;
            final /* synthetic */ String $message;
            final /* synthetic */ String $language;
            {
                this.$message = $message;
                this.$language = $language;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        String translation = Translator.access$getTranslationFromEnglish(Translator.INSTANCE, this.$message, this.$language);
                        ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied translation to clipboard: \u00a7f" + translation, false, null, 6, null);
                        OSUtils.INSTANCE.copyToClipboard(translation);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public final boolean isEnabled() {
        return this.getConfig().translateOnClick;
    }

    private static final boolean onChat$lambda$0(IChatComponent $this$transformIf) {
        Intrinsics.checkNotNullParameter($this$transformIf, "$this$transformIf");
        List list = $this$transformIf.func_150253_a();
        Intrinsics.checkNotNullExpressionValue(list, "getSiblings(...)");
        return !((Collection)list).isEmpty();
    }

    private static final IChatComponent onChat$lambda$1(IChatComponent $this$transformIf) {
        Intrinsics.checkNotNullParameter($this$transformIf, "$this$transformIf");
        List list = $this$transformIf.func_150253_a();
        Intrinsics.checkNotNullExpressionValue(list, "getSiblings(...)");
        Object t = CollectionsKt.last(list);
        Intrinsics.checkNotNullExpressionValue(t, "last(...)");
        return (IChatComponent)t;
    }

    private static final void onConfigReload$lambda$2() {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastUserChange), DurationKt.toDuration(50, DurationUnit.MILLISECONDS)) < 0) {
            return;
        }
        lastUserChange = SimpleTimeMark.Companion.now-uFjCsEo();
        String text = (String)Translator.INSTANCE.getConfig().languageCode.get();
        Intrinsics.checkNotNull(text);
        if (((CharSequence)text).length() == 0) {
            Translator.INSTANCE.getConfig().languageName.set(TranslatableLanguage.ENGLISH);
        } else {
            for (TranslatableLanguage language : TranslatableLanguage.values()) {
                if (!StringsKt.equals(language.getLanguageCode(), text, true)) continue;
                Translator.INSTANCE.getConfig().languageName.set(language);
                return;
            }
            Translator.INSTANCE.getConfig().languageName.set(TranslatableLanguage.UNKNOWN);
        }
    }

    private static final void onConfigReload$lambda$3() {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastUserChange), DurationKt.toDuration(50, DurationUnit.MILLISECONDS)) < 0) {
            return;
        }
        lastUserChange = SimpleTimeMark.Companion.now-uFjCsEo();
        Translator.INSTANCE.getConfig().languageCode.set(((TranslatableLanguage)((Object)Translator.INSTANCE.getConfig().languageName.get())).getLanguageCode());
    }

    public static final /* synthetic */ TranslatorConfig access$getConfig(Translator $this) {
        return $this.getConfig();
    }

    public static final /* synthetic */ String access$getTranslationToEnglish(Translator $this, String message) {
        return $this.getTranslationToEnglish(message);
    }

    public static final /* synthetic */ String access$getTranslationFromEnglish(Translator $this, String message, String lang) {
        return $this.getTranslationFromEnglish(message, lang);
    }
}

