/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.discordipc;

import at.hannibal2.skyhanni.deps.discordipc.IPCListener;
import at.hannibal2.skyhanni.deps.discordipc.entities.Callback;
import at.hannibal2.skyhanni.deps.discordipc.entities.DiscordBuild;
import at.hannibal2.skyhanni.deps.discordipc.entities.Packet;
import at.hannibal2.skyhanni.deps.discordipc.entities.RichPresence;
import at.hannibal2.skyhanni.deps.discordipc.entities.User;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.Pipe;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.PipeStatus;
import at.hannibal2.skyhanni.deps.discordipc.exceptions.NoDiscordClientException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;

public final class IPCClient
implements Closeable {
    private final long clientId;
    private final boolean debugMode;
    private final HashMap<String, Callback> callbacks = new HashMap();
    private volatile Pipe pipe;
    private IPCListener listener = null;
    private Thread readThread = null;
    private String encoding = "UTF-8";

    public IPCClient(long clientId) {
        this.clientId = clientId;
        this.debugMode = false;
    }

    public IPCClient(long clientId, boolean debugMode) {
        this.clientId = clientId;
        this.debugMode = debugMode;
    }

    private static int getPID() {
        String pr = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(pr.substring(0, pr.indexOf(64)));
    }

    public void setListener(IPCListener listener) {
        this.listener = listener;
        if (this.pipe != null) {
            this.pipe.setListener(listener);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public long getClientID() {
        return this.clientId;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void connect(DiscordBuild ... preferredOrder) throws NoDiscordClientException {
        this.checkConnected(false);
        this.callbacks.clear();
        this.pipe = null;
        this.pipe = Pipe.openPipe(this, this.clientId, this.callbacks, preferredOrder);
        if (this.debugMode) {
            System.out.println("Client is now connected and ready!");
        }
        if (this.listener != null) {
            this.listener.onReady(this);
        }
        this.startReading();
    }

    public void sendRichPresence(RichPresence presence) {
        this.sendRichPresence(presence, null);
    }

    public void sendRichPresence(RichPresence presence, Callback callback) {
        this.checkConnected(true);
        if (this.debugMode) {
            System.out.println("Sending RichPresence to discord: " + (presence == null ? null : presence.toJson().toString()));
        }
        JsonObject finalObject = new JsonObject();
        JsonObject args2 = new JsonObject();
        finalObject.addProperty("cmd", "SET_ACTIVITY");
        args2.addProperty("pid", (Number)IPCClient.getPID());
        args2.add("activity", (JsonElement)(presence == null ? new JsonObject() : presence.toJson()));
        finalObject.add("args", (JsonElement)args2);
        this.pipe.send(Packet.OpCode.FRAME, finalObject, callback);
    }

    public void subscribe(Event sub) {
        this.subscribe(sub, null);
    }

    public void subscribe(Event sub, Callback callback) {
        this.checkConnected(true);
        if (!sub.isSubscribable()) {
            throw new IllegalStateException("Cannot subscribe to " + (Object)((Object)sub) + " event!");
        }
        if (this.debugMode) {
            System.out.println(String.format("Subscribing to Event: %s", sub.name()));
        }
        JsonObject pipeData = new JsonObject();
        pipeData.addProperty("cmd", "SUBSCRIBE");
        pipeData.addProperty("evt", sub.name());
        this.pipe.send(Packet.OpCode.FRAME, pipeData, callback);
    }

    public void respondToJoinRequest(User user, ApprovalMode approvalMode, Callback callback) {
        this.checkConnected(true);
        if (user != null) {
            if (this.debugMode) {
                System.out.println(String.format("Sending response to %s as %s", user.getName(), approvalMode.name()));
            }
            JsonObject pipeData = new JsonObject();
            pipeData.addProperty("cmd", approvalMode == ApprovalMode.ACCEPT ? "SEND_ACTIVITY_JOIN_INVITE" : "CLOSE_ACTIVITY_REQUEST");
            JsonObject args2 = new JsonObject();
            args2.addProperty("user_id", user.getId());
            pipeData.add("args", (JsonElement)args2);
            this.pipe.send(Packet.OpCode.FRAME, pipeData, callback);
        }
    }

    public PipeStatus getStatus() {
        if (this.pipe == null) {
            return PipeStatus.UNINITIALIZED;
        }
        return this.pipe.getStatus();
    }

    @Override
    public void close() {
        block2: {
            this.checkConnected(true);
            try {
                this.pipe.close();
            }
            catch (IOException e) {
                if (!this.debugMode) break block2;
                System.out.println(String.format("Failed to close pipe: %s", e));
            }
        }
    }

    public DiscordBuild getDiscordBuild() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getDiscordBuild();
    }

    public User getCurrentUser() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getCurrentUser();
    }

    private void checkConnected(boolean connected) {
        if (connected && this.getStatus() != PipeStatus.CONNECTED) {
            throw new IllegalStateException(String.format("IPCClient (ID: %d) is not connected!", this.clientId));
        }
        if (!connected && this.getStatus() == PipeStatus.CONNECTED) {
            throw new IllegalStateException(String.format("IPCClient (ID: %d) is already connected!", this.clientId));
        }
    }

    private void startReading() {
        IPCClient localInstance = this;
        this.readThread = new Thread(() -> this.lambda$startReading$0(localInstance), "IPCClient-Reader");
        if (this.debugMode) {
            System.out.println("Starting IPCClient reading thread!");
        }
        this.readThread.start();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$startReading$0(IPCClient localInstance) {
        try {
            while (true) lbl-1000:
            // 6 sources

            {
                if ((p = this.pipe.read()).getOp() == Packet.OpCode.CLOSE) {
                    this.pipe.setStatus(PipeStatus.DISCONNECTED);
                    if (this.listener == null) return;
                    this.listener.onClose(localInstance, p.getJson());
                    return;
                }
                json = p.getJson();
                if (json == null) continue;
                event = Event.of(json.has("evt") != false && json.get("evt").isJsonNull() == false ? json.getAsJsonPrimitive("evt").getAsString() : null);
                nonce = json.has("nonce") != false && json.get("nonce").isJsonNull() == false ? json.getAsJsonPrimitive("nonce").getAsString() : null;
                switch (1.$SwitchMap$com$jagrosh$discordipc$IPCClient$Event[event.ordinal()]) {
                    case 1: {
                        if (nonce == null || !this.callbacks.containsKey(nonce)) break;
                        this.callbacks.remove(nonce).succeed(p);
                        break;
                    }
                    case 2: {
                        if (nonce == null || !this.callbacks.containsKey(nonce)) break;
                        this.callbacks.remove(nonce).fail(json.has("data") != false && json.getAsJsonObject("data").has("message") != false ? json.getAsJsonObject("data").getAsJsonObject("message").getAsString() : null);
                        break;
                    }
                    case 3: {
                        if (!this.debugMode) break;
                        System.out.println("Reading thread received a 'join' event.");
                        break;
                    }
                    case 4: {
                        if (!this.debugMode) break;
                        System.out.println("Reading thread received a 'spectate' event.");
                        break;
                    }
                    case 5: {
                        if (!this.debugMode) break;
                        System.out.println("Reading thread received a 'join request' event.");
                        break;
                    }
                    case 6: {
                        if (!this.debugMode) break;
                        System.out.println("Reading thread encountered an event with an unknown type: " + json.getAsJsonPrimitive("evt").getAsString());
                        break;
                    }
                }
                if (this.listener == null || !json.has("cmd") || !json.getAsJsonPrimitive("cmd").getAsString().equals("DISPATCH")) continue;
                try {
                    data = json.getAsJsonObject("data");
                    switch (1.$SwitchMap$com$jagrosh$discordipc$IPCClient$Event[Event.of(json.getAsJsonPrimitive("evt").getAsString()).ordinal()]) {
                        case 3: {
                            this.listener.onActivityJoin(localInstance, data.getAsJsonObject("secret").getAsString());
                            break;
                        }
                        case 4: {
                            this.listener.onActivitySpectate(localInstance, data.getAsJsonObject("secret").getAsString());
                            break;
                        }
                        case 5: {
                            u = data.getAsJsonObject("user");
                            user = new User(u.getAsJsonPrimitive("username").getAsString(), u.getAsJsonPrimitive("discriminator").getAsString(), Long.parseLong(u.getAsJsonPrimitive("id").getAsString()), u.has("avatar") != false ? u.getAsJsonPrimitive("avatar").getAsString() : null);
                            this.listener.onActivityJoinRequest(localInstance, data.has("secret") != false ? data.getAsJsonObject("secret").getAsString() : null, user);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(String.format("Exception when handling event: %s", new Object[]{e}));
                    continue;
                }
                break;
            }
        }
        catch (JsonParseException | IOException ex) {
            if (ex instanceof IOException) {
                System.out.println(String.format("Reading thread encountered an IOException: %s", new Object[]{ex}));
            } else {
                System.out.println(String.format("Reading thread encountered an JSONException: %s", new Object[]{ex}));
            }
            this.pipe.setStatus(PipeStatus.DISCONNECTED);
            if (this.listener == null) return;
            this.listener.onDisconnect(localInstance, ex);
        }
        ** GOTO lbl-1000
    }

    public static enum Event {
        NULL(false),
        READY(false),
        ERROR(false),
        ACTIVITY_JOIN(true),
        ACTIVITY_SPECTATE(true),
        ACTIVITY_JOIN_REQUEST(true),
        UNKNOWN(false);

        private final boolean subscribable;

        private Event(boolean subscribable) {
            this.subscribable = subscribable;
        }

        static Event of(String str) {
            if (str == null) {
                return NULL;
            }
            for (Event s : Event.values()) {
                if (s == UNKNOWN || !s.name().equalsIgnoreCase(str)) continue;
                return s;
            }
            return UNKNOWN;
        }

        public boolean isSubscribable() {
            return this.subscribable;
        }
    }

    public static enum ApprovalMode {
        ACCEPT,
        DENY;

    }
}

