/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.ScoreboardData;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.SlayerChangeEvent;
import at.hannibal2.skyhanni.events.SlayerProgressChangeEvent;
import at.hannibal2.skyhanni.events.SlayerQuestCompleteEvent;
import at.hannibal2.skyhanni.features.slayer.SlayerType;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RecalculatingValue;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeLimitedCache;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0004\b\u001e\u0010\u001aR:\u0010 \u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\"\u0010#\u001a\u00020\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\"\u0010)\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b)\u0010\u0006\"\u0004\b+\u0010,R\"\u0010-\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010*\u001a\u0004\b-\u0010\u0006\"\u0004\b.\u0010,R\"\u0010/\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\"\u00105\u001a\u00020\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u0010$\u001a\u0004\b6\u0010&\"\u0004\b7\u0010(R\"\u00108\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00100\u001a\u0004\b9\u00102\"\u0004\b:\u00104R\u001d\u0010>\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010\u001a\u00a8\u0006?"}, d2={"Lat/hannibal2/skyhanni/data/SlayerAPI;", "", "<init>", "()V", "", "hasActiveSlayerQuest", "()Z", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "", "amount", "Lkotlin/Pair;", "", "", "getItemNameAndPrice", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;I)Lkotlin/Pair;", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "grabActiveSlayer", "()Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "getSlayerTypeForCurrentArea", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "nameCache", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "questStartTime", "J", "getQuestStartTime-uFjCsEo", "()J", "setQuestStartTime-gJLAdNM", "(J)V", "isInCorrectArea", "Z", "setInCorrectArea", "(Z)V", "isInAnyArea", "setInAnyArea", "latestSlayerCategory", "Ljava/lang/String;", "getLatestSlayerCategory", "()Ljava/lang/String;", "setLatestSlayerCategory", "(Ljava/lang/String;)V", "latestWrongAreaWarning", "getLatestWrongAreaWarning-uFjCsEo", "setLatestWrongAreaWarning-gJLAdNM", "latestSlayerProgress", "getLatestSlayerProgress", "setLatestSlayerProgress", "activeSlayer$delegate", "Lat/hannibal2/skyhanni/utils/RecalculatingValue;", "getActiveSlayer", "activeSlayer", "1.8.9"})
public final class SlayerAPI {
    @NotNull
    public static final SlayerAPI INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static TimeLimitedCache<Pair<NEUInternalName, Integer>, Pair<String, Double>> nameCache;
    private static long questStartTime;
    private static boolean isInCorrectArea;
    private static boolean isInAnyArea;
    @NotNull
    private static String latestSlayerCategory;
    private static long latestWrongAreaWarning;
    @NotNull
    private static String latestSlayerProgress;
    @NotNull
    private static final RecalculatingValue activeSlayer$delegate;

    private SlayerAPI() {
    }

    public final long getQuestStartTime-uFjCsEo() {
        return questStartTime;
    }

    public final void setQuestStartTime-gJLAdNM(long l) {
        questStartTime = l;
    }

    public final boolean isInCorrectArea() {
        return isInCorrectArea;
    }

    public final void setInCorrectArea(boolean bl) {
        isInCorrectArea = bl;
    }

    public final boolean isInAnyArea() {
        return isInAnyArea;
    }

    public final void setInAnyArea(boolean bl) {
        isInAnyArea = bl;
    }

    @NotNull
    public final String getLatestSlayerCategory() {
        return latestSlayerCategory;
    }

    public final void setLatestSlayerCategory(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        latestSlayerCategory = string2;
    }

    public final long getLatestWrongAreaWarning-uFjCsEo() {
        return latestWrongAreaWarning;
    }

    public final void setLatestWrongAreaWarning-gJLAdNM(long l) {
        latestWrongAreaWarning = l;
    }

    @NotNull
    public final String getLatestSlayerProgress() {
        return latestSlayerProgress;
    }

    public final void setLatestSlayerProgress(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        latestSlayerProgress = string2;
    }

    public final boolean hasActiveSlayerQuest() {
        return !Intrinsics.areEqual(latestSlayerCategory, "");
    }

    @NotNull
    public final Pair<String, Double> getItemNameAndPrice(@NotNull NEUInternalName internalName, int amount) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        return nameCache.getOrPut(TuplesKt.to(internalName, amount), () -> SlayerAPI.getItemNameAndPrice$lambda$0(amount, internalName));
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Slayer");
        if (!this.hasActiveSlayerQuest()) {
            event.addIrrelevant("no active slayer quest");
            return;
        }
        event.addData(SlayerAPI::onDebugDataCollect$lambda$1);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)event.getMessage(), "\u00a7r\u00a75\u00a7lSLAYER QUEST STARTED!", false, 2, null)) {
            questStartTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        if (Intrinsics.areEqual(event.getMessage(), "  \u00a7r\u00a7a\u00a7lSLAYER QUEST COMPLETE!")) {
            new SlayerQuestCompleteEvent().postAndCatch();
        }
    }

    @Nullable
    public final SlayerType getActiveSlayer() {
        return (SlayerType)((Object)activeSlayer$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]));
    }

    private final SlayerType grabActiveSlayer() {
        for (String line : ScoreboardData.INSTANCE.getSidebarLinesFormatted()) {
            SlayerType slayerType = SlayerType.Companion.getByName(line);
            if (slayerType == null) continue;
            SlayerType it = slayerType;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        String slayerProgress;
        String string2;
        String slayerQuest;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (ProfileStorageData.INSTANCE.getProfileSpecific() == null) {
            return;
        }
        String string3 = CollectionUtils.nextAfter$default(CollectionUtils.INSTANCE, ScoreboardData.INSTANCE.getSidebarLinesFormatted(), "Slayer Quest", 0, 2, null);
        if (string3 == null) {
            string3 = "";
        }
        if (!Intrinsics.areEqual(slayerQuest = string3, latestSlayerCategory)) {
            String old = latestSlayerCategory;
            latestSlayerCategory = slayerQuest;
            new SlayerChangeEvent(old, latestSlayerCategory).postAndCatch();
        }
        if ((string2 = CollectionUtils.INSTANCE.nextAfter(ScoreboardData.INSTANCE.getSidebarLinesFormatted(), "Slayer Quest", 2)) == null) {
            string2 = "";
        }
        if (!Intrinsics.areEqual(latestSlayerProgress, slayerProgress = string2)) {
            new SlayerProgressChangeEvent(latestSlayerProgress, slayerProgress).postAndCatch();
            latestSlayerProgress = slayerProgress;
        }
        if (LorenzTickEvent.isMod$default(event, 5, 0, 2, null)) {
            boolean bl;
            if (LorenzUtils.INSTANCE.isStrandedProfile()) {
                isInAnyArea = true;
                bl = true;
            } else {
                SlayerType slayerTypeForCurrentArea = this.getSlayerTypeForCurrentArea();
                isInAnyArea = slayerTypeForCurrentArea != null;
                bl = slayerTypeForCurrentArea == this.getActiveSlayer() && slayerTypeForCurrentArea != null;
            }
            isInCorrectArea = bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final SlayerType getSlayerTypeForCurrentArea() {
        String string2 = LorenzUtils.INSTANCE.getSkyBlockArea();
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 1848022370: {
                if (string2.equals("Burning Desert")) {
                    n = 1;
                }
                break;
            }
            case -2064970994: {
                if (string2.equals("Spider Mound")) {
                    n = 1;
                }
                break;
            }
            case -1644502724: {
                if (string2.equals("Coal Mine")) {
                    n = 2;
                }
                break;
            }
            case 1451041782: {
                if (string2.equals("Stronghold")) {
                    n = 3;
                }
                break;
            }
            case 312628332: {
                if (string2.equals("The End")) {
                    n = 4;
                }
                break;
            }
            case -1508640612: {
                if (string2.equals("Arachne's Sanctuary")) {
                    n = 1;
                }
                break;
            }
            case -1895003037: {
                if (string2.equals("Zealot Bruiser Hideout")) {
                    n = 4;
                }
                break;
            }
            case -112831786: {
                if (string2.equals("The Wasteland")) {
                    n = 3;
                }
                break;
            }
            case 79318699: {
                if (string2.equals("Ruins")) {
                    n = 5;
                }
                break;
            }
            case 963454073: {
                if (string2.equals("Oubliette")) {
                    n = 6;
                }
                break;
            }
            case -602844313: {
                if (string2.equals("Howling Cave")) {
                    n = 5;
                }
                break;
            }
            case 1036208985: {
                if (string2.equals("Dragon's Nest")) {
                    n = 4;
                }
                break;
            }
            case -1562428315: {
                if (string2.equals("Stillgore Ch\u00e2teau")) {
                    n = 6;
                }
                break;
            }
            case -1877764152: {
                if (string2.equals("Smoldering Tomb")) {
                    n = 3;
                }
                break;
            }
            case -344012029: {
                if (string2.equals("Arachne's Burrow")) {
                    n = 1;
                }
                break;
            }
            case 1000395423: {
                if (string2.equals("Graveyard")) {
                    n = 2;
                }
                break;
            }
            case 641884637: {
                if (string2.equals("Void Sepulture")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                SlayerType slayerType = SlayerType.REVENANT;
                return slayerType;
            }
            case 1: {
                SlayerType slayerType = SlayerType.TARANTULA;
                return slayerType;
            }
            case 5: {
                SlayerType slayerType = SlayerType.SVEN;
                return slayerType;
            }
            case 4: {
                SlayerType slayerType = SlayerType.VOID;
                return slayerType;
            }
            case 3: {
                SlayerType slayerType = SlayerType.INFERNO;
                return slayerType;
            }
            case 6: {
                SlayerType slayerType = SlayerType.VAMPIRE;
                return slayerType;
            }
            default: {
                return null;
            }
        }
    }

    private static final Pair getItemNameAndPrice$lambda$0(int $amount, NEUInternalName $internalName) {
        Pair<String, Double> pair;
        Intrinsics.checkNotNullParameter($internalName, "$internalName");
        String amountFormat = $amount != 1 ? "\u00a77" + $amount + "x \u00a7r" : "";
        String displayName = ItemUtils.INSTANCE.getItemName($internalName);
        double price = NEUItems.getPrice$default(NEUItems.INSTANCE, $internalName, null, null, 3, null);
        Double d = NEUItems.INSTANCE.getNpcPriceOrNull($internalName);
        double npcPrice = d != null ? d : 0.0;
        double maxPrice = RangesKt.coerceAtLeast(npcPrice, price);
        double totalPrice = maxPrice * (double)$amount;
        String format = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, totalPrice, false, 1, null);
        if (Intrinsics.areEqual($internalName, NEUInternalName.Companion.getSKYBLOCK_COIN())) {
            pair = TuplesKt.to("\u00a76" + format + " coins", totalPrice);
        } else {
            String priceFormat = " \u00a77(\u00a76" + format + " coins\u00a77)";
            pair = TuplesKt.to(amountFormat + displayName + priceFormat, totalPrice);
        }
        return pair;
    }

    private static final Unit onDebugDataCollect$lambda$1(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("activeSlayer: " + (Object)((Object)INSTANCE.getActiveSlayer()));
        $this$addData.add("isInCorrectArea: " + isInCorrectArea);
        $this$addData.add("isInAnyArea: " + isInAnyArea);
        $this$addData.add("latestSlayerProgress: " + latestSlayerProgress);
        return Unit.INSTANCE;
    }

    private static final SlayerType activeSlayer_delegate$lambda$2() {
        return INSTANCE.grabActiveSlayer();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SlayerAPI.class, "activeSlayer", "getActiveSlayer()Lat/hannibal2/skyhanni/features/slayer/SlayerType;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SlayerAPI();
        nameCache = new TimeLimitedCache(DurationKt.toDuration(1, DurationUnit.MINUTES), null, 2, null);
        questStartTime = SimpleTimeMark.Companion.farPast();
        latestSlayerCategory = "";
        latestWrongAreaWarning = SimpleTimeMark.Companion.farPast();
        latestSlayerProgress = "";
        activeSlayer$delegate = new RecalculatingValue(DurationKt.toDuration(1, DurationUnit.SECONDS), SlayerAPI::activeSlayer_delegate$lambda$2, null);
    }
}

