/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.EntityData$onTick$;
import at.hannibal2.skyhanni.events.EntityHealthUpdateEvent;
import at.hannibal2.skyhanni.events.EntityMaxHealthUpdateEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.entity.EntityDisplayNameEvent;
import at.hannibal2.skyhanni.events.entity.EntityHealthDisplayEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.TimeLimitedCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S1CPacketEntityMetadata;
import net.minecraft.util.ChatComponentText;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u0017\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00140#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/data/EntityData;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onHealthUpdatePacket", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lnet/minecraft/entity/Entity;", "entity", "Lnet/minecraft/util/ChatComponentText;", "oldValue", "getDisplayName", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/ChatComponentText;)Lnet/minecraft/util/ChatComponentText;", "chatComponent", "postRenderNametag", "", "text", "getHealthDisplay", "(Ljava/lang/String;)Ljava/lang/String;", "", "Lnet/minecraft/entity/EntityLivingBase;", "", "maxHealthMap", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "nametagCache", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "healthDisplayCache", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nEntityData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityData.kt\nat/hannibal2/skyhanni/data/EntityData\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,117:1\n172#2:118\n477#3:119\n*S KotlinDebug\n*F\n+ 1 EntityData.kt\nat/hannibal2/skyhanni/data/EntityData\n*L\n40#1:118\n40#1:119\n*E\n"})
public final class EntityData {
    @NotNull
    public static final EntityData INSTANCE = new EntityData();
    @NotNull
    private static final Map<EntityLivingBase, Integer> maxHealthMap = new LinkedHashMap();
    @NotNull
    private static final TimeLimitedCache<Entity, ChatComponentText> nametagCache = new TimeLimitedCache(DurationKt.toDuration(50, DurationUnit.MILLISECONDS), null, 2, null);
    @NotNull
    private static final TimeLimitedCache<String, String> healthDisplayCache = new TimeLimitedCache(DurationKt.toDuration(50, DurationUnit.MILLISECONDS), null, 2, null);

    private EntityData() {
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        EntityUtils this_$iv = EntityUtils.INSTANCE;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv = this_$iv.getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv, onTick$$inlined$getEntities$1.INSTANCE);
        Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Iterator<Entity> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            EntityLivingBase entity = (EntityLivingBase)iterator2.next();
            int maxHealth = LorenzUtils.INSTANCE.getBaseMaxHealth(entity);
            int oldMaxHealth = ((Number)maxHealthMap.getOrDefault(entity, -1)).intValue();
            if (oldMaxHealth == maxHealth) continue;
            Integer n = maxHealth;
            maxHealthMap.put(entity, n);
            new EntityMaxHealthUpdateEvent(entity, LorenzUtils.INSTANCE.derpy(maxHealth)).postAndCatch();
        }
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.repeatSeconds(30)) {
            maxHealthMap.keySet().removeIf(arg_0 -> EntityData.onSecondPassed$lambda$1(EntityData::onSecondPassed$lambda$0, arg_0));
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        maxHealthMap.clear();
    }

    @HandleEvent
    public final void onHealthUpdatePacket(@NotNull PacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Packet<?> packet = event.getPacket();
        if (!(packet instanceof S1CPacketEntityMetadata)) {
            return;
        }
        List list = ((S1CPacketEntityMetadata)packet).func_149376_c();
        if (list == null) {
            return;
        }
        List watchableObjects = list;
        int entityId = ((S1CPacketEntityMetadata)packet).func_149375_d();
        Entity entity = EntityUtils.INSTANCE.getEntityByID(entityId);
        if (entity == null) {
            return;
        }
        Entity entity2 = entity;
        if (entity2 instanceof EntityArmorStand) {
            return;
        }
        if (entity2 instanceof EntityXPOrb) {
            return;
        }
        if (entity2 instanceof EntityItem) {
            return;
        }
        if (entity2 instanceof EntityItemFrame) {
            return;
        }
        if (entity2 instanceof EntityOtherPlayerMP) {
            return;
        }
        if (entity2 instanceof EntityPlayerSP) {
            return;
        }
        for (DataWatcher.WatchableObject watchableObject : watchableObjects) {
            int dataValueId = watchableObject.func_75672_a();
            Object any2 = watchableObject.func_75669_b();
            if (dataValueId != 6) continue;
            Intrinsics.checkNotNull(any2, "null cannot be cast to non-null type kotlin.Float");
            int health = (int)((Float)any2).floatValue();
            if (entity2 instanceof EntityWither && health == 300 && entityId < 0) {
                return;
            }
            if (!(entity2 instanceof EntityLivingBase)) continue;
            new EntityHealthUpdateEvent((EntityLivingBase)entity2, LorenzUtils.INSTANCE.derpy(health)).postAndCatch();
        }
    }

    @JvmStatic
    @NotNull
    public static final ChatComponentText getDisplayName(@NotNull Entity entity, @NotNull ChatComponentText oldValue) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(oldValue, "oldValue");
        return INSTANCE.postRenderNametag(entity, oldValue);
    }

    private final ChatComponentText postRenderNametag(Entity entity, ChatComponentText chatComponent) {
        return nametagCache.getOrPut(entity, () -> EntityData.postRenderNametag$lambda$2(entity, chatComponent));
    }

    @JvmStatic
    @NotNull
    public static final String getHealthDisplay(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return healthDisplayCache.getOrPut(text, () -> EntityData.getHealthDisplay$lambda$3(text));
    }

    private static final boolean onSecondPassed$lambda$0(EntityLivingBase it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.field_70128_L;
    }

    private static final boolean onSecondPassed$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ChatComponentText postRenderNametag$lambda$2(Entity $entity, ChatComponentText $chatComponent) {
        Intrinsics.checkNotNullParameter($entity, "$entity");
        Intrinsics.checkNotNullParameter($chatComponent, "$chatComponent");
        EntityDisplayNameEvent event = new EntityDisplayNameEvent($entity, $chatComponent);
        event.postAndCatch();
        return event.getChatComponent();
    }

    private static final String getHealthDisplay$lambda$3(String $text) {
        Intrinsics.checkNotNullParameter($text, "$text");
        EntityHealthDisplayEvent event = new EntityHealthDisplayEvent($text);
        event.postAndCatch();
        return event.getText();
    }
}

