/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.misc;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorKeybind;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TrevorTheTrapperConfig {
    @Expose
    @ConfigOption(name="Enable Data Tracker", desc="Track all of your data from doing Trevor Quests.\nShows based on the setting below.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean dataTracker = true;
    @Expose
    @ConfigOption(name="Show Between Quests", desc="Show the tracker during and between quests otherwise it will only show during them.\nWill show in the Trapper's Den regardless. \u00a7cToggle 'Enable Data Tracker' above.")
    @ConfigEditorBoolean
    public boolean displayType = true;
    @Expose
    @ConfigOption(name="Text Format", desc="Drag text to change the appearance of the overlay.")
    @ConfigEditorDraggableList
    public List<TrackerEntry> textFormat = new ArrayList<TrackerEntry>(Arrays.asList(TrackerEntry.TITLE, TrackerEntry.QUESTS_STARTED, TrackerEntry.TOTAL_PELTS, TrackerEntry.PELTS_PER_HOUR, TrackerEntry.SPACER_1, TrackerEntry.KILLED, TrackerEntry.TRACKABLE, TrackerEntry.UNTRACKABLE, TrackerEntry.UNDETECTED, TrackerEntry.ENDANGERED, TrackerEntry.ELUSIVE));
    @Expose
    @ConfigLink(owner=TrevorTheTrapperConfig.class, field="dataTracker")
    public Position position = new Position(10, 80, false, true);
    @Expose
    @ConfigOption(name="Trapper Solver", desc="Assist in finding Trevor's mobs.\n\u00a7eNote: May not always work as expected.\n\u00a7cWill not help you to find rabbits or sheep in the Oasis!")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean trapperSolver = true;
    @Expose
    @ConfigOption(name="Mob Dead Warning", desc="Show a message when Trevor's mob dies.")
    @ConfigEditorBoolean
    public boolean trapperMobDiedMessage = true;
    @Expose
    @ConfigOption(name="Warp to Trapper", desc="Warp to Trevor's Den. Works only inside the Farming Islands.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean warpToTrapper = false;
    @Expose
    @ConfigOption(name="Accept Trapper Quest", desc="Click this key after the chat prompt to accept Trevor's quest.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean acceptQuest = false;
    @Expose
    @ConfigOption(name="Trapper Hotkey", desc="Press this key to warp to Trevor's Den or to accept the quest. \u00a7eRequires the relevant above settings to be toggled")
    @ConfigEditorKeybind(defaultKey=0)
    public int keyBindWarpTrapper = 0;
    @Expose
    @ConfigOption(name="Trapper Cooldown", desc="Change the color of Trevor and adds a cooldown over his head.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean trapperTalkCooldown = true;
    @Expose
    @ConfigOption(name="Trapper Cooldown GUI", desc="Show the cooldown on screen in an overlay (intended for Abiphone users).")
    @ConfigEditorBoolean
    public boolean trapperCooldownGui = false;
    @Expose
    @ConfigLink(owner=TrevorTheTrapperConfig.class, field="trapperCooldownGui")
    public Position trapperCooldownPos = new Position(10, 10, false, true);

    public static enum TrackerEntry implements HasLegacyId
    {
        TITLE("\u00a7b\u00a7lTrevor Data Tracker", 0),
        QUESTS_STARTED("\u00a7b1,428 \u00a79Quests Started", 1),
        TOTAL_PELTS("\u00a7b11,281 \u00a75Total Pelts Gained", 2),
        PELTS_PER_HOUR("\u00a7b2,448 \u00a75Pelts Per Hour", 3),
        SPACER_1("", 4),
        KILLED("\u00a7b850 \u00a7cKilled Animals", 5),
        SELF_KILLING("\u00a7b153 \u00a7cSelf Killing Animals", 6),
        TRACKABLE("\u00a7b788 \u00a7fTrackable Animals", 7),
        UNTRACKABLE("\u00a7b239 \u00a7aUntrackable Animals", 8),
        UNDETECTED("\u00a7b115 \u00a79Undetected Animals", 9),
        ENDANGERED("\u00a7b73 \u00a75Endangered Animals", 10),
        ELUSIVE("\u00a7b12 \u00a76Elusive Animals", 11);

        private final String str;
        private final int legacyId;

        private TrackerEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private TrackerEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

