/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.inventory;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.utils.ItemPriceSource;
import at.hannibal2.skyhanni.utils.RenderUtils;
import com.google.gson.annotations.Expose;

public class SackDisplayConfig {
    @Expose
    @ConfigOption(name="Enabled", desc="Show contained items inside a sack inventory.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean enabled = false;
    @Expose
    @ConfigOption(name="Highlight Full", desc="Highlight items that are full in red.\n\u00a7eDoes not need the option above to be enabled.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean highlightFull = true;
    @Expose
    @ConfigOption(name="Number Format", desc="Either show Default, Formatted or Unformatted numbers.\n\u00a7eDefault: \u00a772,240/2.2k\n\u00a7eFormatted: \u00a772.2k/2.2k\n\u00a7eUnformatted: \u00a772,240/2,200")
    @ConfigEditorDropdown
    public NumberFormatEntry numberFormat = NumberFormatEntry.FORMATTED;
    @Expose
    @ConfigOption(name="Alignment", desc="Change the alignment for numbers and money.")
    @ConfigEditorDropdown
    public RenderUtils.HorizontalAlignment alignment = RenderUtils.HorizontalAlignment.LEFT;
    @Expose
    @ConfigOption(name="Extra space", desc="Space between each line of text.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=10.0f, minStep=1.0f)
    public int extraSpace = 1;
    @Expose
    @ConfigOption(name="Sorting Type", desc="Sorting type of items in sack.")
    @ConfigEditorDropdown
    public SortingTypeEntry sortingType = SortingTypeEntry.DESC_STORED;
    @Expose
    @ConfigOption(name="Item To Show", desc="Choose how many items are displayed. (Some sacks have too many items to fit\nin larger GUI scales, like the nether sack.)")
    @ConfigEditorSlider(minValue=0.0f, maxValue=45.0f, minStep=1.0f)
    public int itemToShow = 15;
    @Expose
    @ConfigOption(name="Show Empty Item", desc="Show empty item quantity in the display.")
    @ConfigEditorBoolean
    public boolean showEmpty = true;
    @Expose
    @ConfigOption(name="Show Price", desc="Show price for each item in sack.")
    @ConfigEditorBoolean
    public boolean showPrice = true;
    @Expose
    @ConfigOption(name="Price Format", desc="Format of the price displayed.\n\u00a7eFormatted: \u00a77(12k)\n\u00a7eUnformatted: \u00a77(12,421)")
    @ConfigEditorDropdown
    public PriceFormatEntry priceFormat = PriceFormatEntry.FORMATTED;
    @Expose
    @ConfigOption(name="Change Price Source", desc="Change what price to use: Bazaar (Sell Offer or Buy Order) or NPC.")
    @ConfigEditorDropdown
    public ItemPriceSource priceSource = ItemPriceSource.BAZAAR_INSTANT_BUY;
    @Expose
    @ConfigLink(owner=SackDisplayConfig.class, field="enabled")
    public Position position = new Position(144, 139, false, true);

    public static enum PriceFormatEntry implements HasLegacyId
    {
        FORMATTED("Formatted", 0),
        UNFORMATTED("Unformatted", 1);

        private final String str;
        private final int legacyId;

        private PriceFormatEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private PriceFormatEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static enum SortingTypeEntry implements HasLegacyId
    {
        DESC_STORED("Descending (Stored)", 0),
        ASC_STORED("Ascending (Stored)", 1),
        DESC_PRICE("Descending (Price)", 2),
        ASC_PRICE("Ascending (Price)", 3);

        private final String str;
        private final int legacyId;

        private SortingTypeEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private SortingTypeEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static enum NumberFormatEntry implements HasLegacyId
    {
        DEFAULT("Default", 0),
        FORMATTED("Formatted", 1),
        UNFORMATTED("Unformatted", 2);

        private final String str;
        private final int legacyId;

        private NumberFormatEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private NumberFormatEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

