/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.garden.pests;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorKeybind;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import com.google.gson.annotations.Expose;

public class PestFinderConfig {
    @Expose
    @ConfigOption(name="Display", desc="Show a display with all known pest locations.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean showDisplay = true;
    @Expose
    @ConfigOption(name="Show Plot in World", desc="Mark infested plot names and world border in the world.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean showPlotInWorld = true;
    @Expose
    @ConfigOption(name="Plot Visibility Type", desc="Choose how to show infested plots in the world.")
    @ConfigEditorDropdown
    public VisibilityType visibilityType = VisibilityType.BOTH;
    @Expose
    @ConfigOption(name="Only With Vacuum", desc="Only show the pest display and waypoints while holding a vacuum in the hand.")
    @ConfigEditorBoolean
    public boolean onlyWithVacuum = true;
    @Expose
    @ConfigOption(name="Show For Seconds", desc="Show plots border for a given amount of seconds after holding a vacuum.\n\u00a7e0 = Always show when holding vacuum")
    @ConfigEditorSlider(minStep=1.0f, minValue=0.0f, maxValue=10.0f)
    public int showBorderForSeconds = 1;
    @Expose
    @ConfigLink(owner=PestFinderConfig.class, field="showDisplay")
    public Position position = new Position(-350, 200, 1.3f);
    @Expose
    @ConfigOption(name="No Pests Title", desc="Show a Title in case of No pests. Useful if you are using the \u00a7eGarden Pest Chat Filter")
    @ConfigEditorBoolean
    public boolean noPestTitle = false;
    @Expose
    @ConfigOption(name="Teleport Hotkey", desc="Press this key to warp to the nearest plot with pests on it.")
    @ConfigEditorKeybind(defaultKey=0)
    public int teleportHotkey = 0;
    @Expose
    @ConfigOption(name="Always Teleport", desc="Allow teleporting with the Teleport Hotkey even when you're already in an infested plot.")
    @ConfigEditorBoolean
    public boolean alwaysTp = false;
    @Expose
    @ConfigOption(name="Back to Garden", desc="Make the Teleport Hotkey warp you to Garden if you don't have any pests.")
    @ConfigEditorBoolean
    public boolean backToGarden = false;

    public static enum VisibilityType {
        BORDER("Border"),
        NAME("Name"),
        BOTH("Both");

        private final String str;

        private VisibilityType(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

