/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.garden.cropmilestones;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import com.google.gson.annotations.Expose;

public class NextConfig {
    @Expose
    @ConfigOption(name="Best Crop Time", desc="List all crops and their ETA till next milestone. Sorts for best crop for getting garden or SkyBlock levels.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean bestDisplay = false;
    @Expose
    @ConfigOption(name="Sort Type", desc="Sort the crops by either garden or SkyBlock EXP.")
    @ConfigEditorDropdown
    public BestTypeEntry bestType = BestTypeEntry.GARDEN_EXP;
    @Expose
    @ConfigOption(name="Only Show Top", desc="Only show the top # crops.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=10.0f, minStep=1.0f)
    public int showOnlyBest = 10;
    @Expose
    @ConfigOption(name="Extend Top List", desc="Add current crop to the list if its lower ranked than the set limit by extending the list.")
    @ConfigEditorBoolean
    public boolean showCurrent = true;
    @Expose
    @ConfigOption(name="Always On", desc="Show the Best Display always while in the garden.")
    @ConfigEditorBoolean
    public boolean bestAlwaysOn = false;
    @Expose
    @ConfigOption(name="Compact Display", desc="A more compact best crop time: Removing the crop name and exp, hide the # number and using a more compact time format.")
    @ConfigEditorBoolean
    public boolean bestCompact = false;
    @Expose
    @ConfigOption(name="Hide Title", desc="Hide the 'Best Crop Time' line entirely.")
    @ConfigEditorBoolean
    public boolean bestHideTitle = false;
    @Expose
    @ConfigLink(owner=NextConfig.class, field="bestDisplay")
    public Position displayPos = new Position(-200, -200, false, true);

    public static enum BestTypeEntry implements HasLegacyId
    {
        GARDEN_EXP("Garden Exp", 0),
        SKYBLOCK_EXP("SkyBlock Exp", 1);

        private final String str;
        private final int legacyId;

        private BestTypeEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private BestTypeEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

