/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorButton;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.features.misc.update.ConfigVersionDisplay;
import at.hannibal2.skyhanni.utils.OSUtils;
import com.google.gson.annotations.Expose;

public class About {
    @ConfigOption(name="Current Version", desc="This is the SkyHanni version you are currently running")
    @ConfigVersionDisplay
    public transient Void currentVersion = null;
    @ConfigOption(name="Check for Updates", desc="Automatically check for updates on each startup")
    @Expose
    @ConfigEditorBoolean
    public boolean autoUpdates = true;
    @ConfigOption(name="Auto Updates", desc="Automatically download new version on each startup")
    @Expose
    @FeatureToggle
    @ConfigEditorBoolean
    public boolean fullAutoUpdates = false;
    @ConfigOption(name="Update Stream", desc="How frequently you want updates for SkyHanni")
    @Expose
    @ConfigEditorDropdown
    public Property<UpdateStream> updateStream = Property.of(UpdateStream.RELEASES);
    @ConfigOption(name="Used Software", desc="Information about used software and licenses")
    @Accordion
    @Expose
    public Licenses licenses = new Licenses();

    public static class Licenses {
        @ConfigOption(name="MoulConfig", desc="MoulConfig is available under the LGPL 3.0 License or later version")
        @ConfigEditorButton(buttonText="Source")
        public Runnable moulConfig = () -> OSUtils.openBrowser("https://github.com/NotEnoughUpdates/MoulConfig");
        @ConfigOption(name="NotEnoughUpdates", desc="NotEnoughUpdates is available under the LGPL 3.0 License or later version")
        @ConfigEditorButton(buttonText="Source")
        public Runnable notEnoughUpdates = () -> OSUtils.openBrowser("https://github.com/NotEnoughUpdates/NotEnoughUpdates");
        @ConfigOption(name="Forge", desc="Forge is available under the LGPL 3.0 license")
        @ConfigEditorButton(buttonText="Source")
        public Runnable forge = () -> OSUtils.openBrowser("https://github.com/MinecraftForge/MinecraftForge");
        @ConfigOption(name="LibAutoUpdate", desc="LibAutoUpdate is available under the BSD 2 Clause License")
        @ConfigEditorButton(buttonText="Source")
        public Runnable libAutoUpdate = () -> OSUtils.openBrowser("https://git.nea.moe/nea/libautoupdate/");
        @ConfigOption(name="Mixin", desc="Mixin is available under the MIT License")
        @ConfigEditorButton(buttonText="Source")
        public Runnable mixin = () -> OSUtils.openBrowser("https://github.com/SpongePowered/Mixin/");
        @ConfigOption(name="DiscordIPC", desc="DiscordIPC is available under the Apache License 2.0")
        @ConfigEditorButton(buttonText="GitHub")
        public Runnable discordRPC = () -> OSUtils.openBrowser("https://github.com/jagrosh/DiscordIPC");
    }

    public static enum UpdateStream {
        NONE("None", "none"),
        BETA("Beta", "pre"),
        RELEASES("Full", "full");

        private final String label;
        private final String stream;

        private UpdateStream(String label, String stream) {
            this.label = label;
            this.stream = stream;
        }

        public String getStream() {
            return this.stream;
        }

        public String toString() {
            return this.label;
        }
    }
}

