/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.core.config;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigGuiManager;
import at.hannibal2.skyhanni.config.Features;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiScreenElementWrapper;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MoulConfigEditor;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.jetbrains.annotations.NotNull;

public class Position {
    @Expose
    private int x;
    @Expose
    private int y;
    @Expose
    private float scale = 1.0f;
    @Expose
    private boolean center = false;
    @Expose
    private boolean centerX;
    @Expose
    private boolean centerY;
    @Expose
    private boolean ignoreCustomScale = false;
    public transient Field linkField;
    private boolean clicked = false;
    public String internalName = null;

    public Position() {
        this(0, 0);
    }

    public Position(int x, int y) {
        this(x, y, false, false);
    }

    public Position(int x, int y, float scale) {
        this.x = x;
        this.y = y;
        this.centerX = false;
        this.centerY = true;
        this.scale = scale;
    }

    public Position(int x, int y, float scale, boolean center) {
        this.x = x;
        this.y = y;
        this.centerX = false;
        this.centerY = true;
        this.scale = scale;
        this.center = center;
    }

    public Position(int x, int y, boolean centerX, boolean centerY) {
        this.x = x;
        this.y = y;
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public void set(Position other) {
        this.x = other.x;
        this.y = other.y;
        this.centerX = other.centerX;
        this.centerY = other.centerY;
        this.scale = other.getScale();
        this.center = other.isCenter();
    }

    public Position setIgnoreCustomScale(boolean ignoreCustomScale) {
        this.ignoreCustomScale = ignoreCustomScale;
        return this;
    }

    public float getEffectiveScale() {
        if (this.ignoreCustomScale) {
            return 1.0f;
        }
        return Math.max(Math.min(this.getScale() * SkyHanniMod.feature.gui.globalScale, 10.0f), 0.1f);
    }

    public float getScale() {
        if (this.scale == 0.0f) {
            return 1.0f;
        }
        return this.scale;
    }

    public boolean isCenter() {
        return this.center;
    }

    public void setScale(float newScale) {
        this.scale = Math.max(Math.min(10.0f, newScale), 0.1f);
    }

    public int getRawX() {
        return this.x;
    }

    public int getRawY() {
        return this.y;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setClicked(boolean state) {
        this.clicked = state;
    }

    public boolean getClicked() {
        return this.clicked;
    }

    public int getAbsX0(int objWidth) {
        int width = new ScaledResolution(Minecraft.func_71410_x()).func_78326_a();
        return this.calcAbs0(this.x, width, objWidth);
    }

    public int getAbsY0(int objHeight) {
        int height = new ScaledResolution(Minecraft.func_71410_x()).func_78328_b();
        return this.calcAbs0(this.y, height, objHeight);
    }

    private int calcAbs0(int axis, int length, int objLength) {
        int ret = axis;
        if (axis < 0) {
            ret = length + axis - objLength;
        }
        if (ret < 0) {
            ret = 0;
        }
        if (ret > length - objLength) {
            ret = length - objLength;
        }
        return ret;
    }

    public int moveX(int deltaX, int objWidth) {
        int screenWidth = new ScaledResolution(Minecraft.func_71410_x()).func_78326_a();
        boolean wasPositiveX = this.x >= 0;
        this.x += deltaX;
        if (wasPositiveX) {
            if (this.x < 0) {
                deltaX -= this.x;
                this.x = 0;
            }
            if (this.x > screenWidth) {
                deltaX += screenWidth - this.x;
                this.x = screenWidth;
            }
        } else {
            if (this.x + 1 > 0) {
                deltaX += -1 - this.x;
                this.x = -1;
            }
            if (this.x + screenWidth < 0) {
                deltaX += -screenWidth - this.x;
                this.x = -screenWidth;
            }
        }
        if (this.x >= 0 && this.x + objWidth / 2 > screenWidth / 2) {
            this.x -= screenWidth - objWidth;
        }
        if (this.x < 0 && this.x + objWidth / 2 <= -screenWidth / 2) {
            this.x += screenWidth - objWidth;
        }
        return deltaX;
    }

    public int moveY(int deltaY, int objHeight) {
        int screenHeight = new ScaledResolution(Minecraft.func_71410_x()).func_78328_b();
        boolean wasPositiveY = this.y >= 0;
        this.y += deltaY;
        if (wasPositiveY) {
            if (this.y < 0) {
                deltaY -= this.y;
                this.y = 0;
            }
            if (this.y > screenHeight) {
                deltaY += screenHeight - this.y;
                this.y = screenHeight;
            }
        } else {
            if (this.y + 1 > 0) {
                deltaY += -1 - this.y;
                this.y = -1;
            }
            if (this.y + screenHeight < 0) {
                deltaY += -screenHeight - this.y;
                this.y = -screenHeight;
            }
        }
        if (this.y >= 0 && this.y - objHeight / 2 > screenHeight / 2) {
            this.y -= screenHeight - objHeight;
        }
        if (this.y < 0 && this.y - objHeight / 2 <= -screenHeight / 2) {
            this.y += screenHeight - objHeight;
        }
        return deltaY;
    }

    public boolean canJumpToConfigOptions() {
        return this.linkField != null && ConfigGuiManager.INSTANCE.getEditorInstance().getProcessedConfig().getOptionFromField(this.linkField) != null;
    }

    public void jumpToConfigOptions() {
        MoulConfigEditor<Features> editor = ConfigGuiManager.INSTANCE.getEditorInstance();
        if (this.linkField == null) {
            return;
        }
        ProcessedOption option = editor.getProcessedConfig().getOptionFromField(this.linkField);
        if (option == null) {
            return;
        }
        editor.search("");
        if (!editor.goToOption(option)) {
            return;
        }
        SkyHanniMod.Companion.setScreenToOpen(new GuiScreenElementWrapper(editor));
    }

    public void setLink(@NotNull ConfigLink configLink) throws NoSuchFieldException {
        this.linkField = configLink.owner().getField(configLink.field());
    }
}

